/*
 * This file was generated by running ./tools/make-iana-constants.py.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */
#include "config.h"

#include "packet-iana-data.h"

const value_string afn_vals[] = {
	{ AFNUM_RESERVED_0,                                 "Reserved"},
	{ AFNUM_IP,                                         "IP (IP version 4)"},
	{ AFNUM_IP6,                                        "IP6 (IP version 6)"},
	{ AFNUM_NSAP,                                       "NSAP"},
	{ AFNUM_HDLC,                                       "HDLC (8-bit multidrop)"},
	{ AFNUM_BBN_1822,                                   "BBN 1822"},
	{ AFNUM_802,                                        "802 (includes all 802 media plus Ethernet 'canonical format')"},
	{ AFNUM_E163,                                       "E.163"},
	{ AFNUM_E164,                                       "E.164 (SMDS, Frame Relay, ATM)"},
	{ AFNUM_F69,                                        "F.69 (Telex)"},
	{ AFNUM_X121,                                       "X.121 (X.25, Frame Relay)"},
	{ AFNUM_IPX,                                        "IPX"},
	{ AFNUM_APPLETALK,                                  "Appletalk"},
	{ AFNUM_DECNET_IV,                                  "Decnet IV"},
	{ AFNUM_BANYAN_VINES,                               "Banyan Vines"},
	{ AFNUM_E164_WITH_NSAP_FORMAT_SUBADDRESS,           "E.164 with NSAP format subaddress"},
	{ AFNUM_DNS,                                        "DNS (Domain Name System)"},
	{ AFNUM_DISTINGUISHED_NAME,                         "Distinguished Name"},
	{ AFNUM_AS_NUMBER,                                  "AS Number"},
	{ AFNUM_XTP_OVER_IP_VERSION_4,                      "XTP over IP version 4"},
	{ AFNUM_XTP_OVER_IP_VERSION_6,                      "XTP over IP version 6"},
	{ AFNUM_XTP_NATIVE_MODE_XTP,                        "XTP native mode XTP"},
	{ AFNUM_FIBRE_CHANNEL_WORLD_WIDE_PORT_NAME,         "Fibre Channel World-Wide Port Name"},
	{ AFNUM_FIBRE_CHANNEL_WORLD_WIDE_NODE_NAME,         "Fibre Channel World-Wide Node Name"},
	{ AFNUM_GWID,                                       "GWID"},
	{ AFNUM_AFI_FOR_L2VPN_INFORMATION,                  "AFI for L2VPN information"},
	{ AFNUM_MPLS_TP_SECTION_ENDPOINT_IDENTIFIER,        "MPLS-TP Section Endpoint Identifier"},
	{ AFNUM_MPLS_TP_LSP_ENDPOINT_IDENTIFIER,            "MPLS-TP LSP Endpoint Identifier"},
	{ AFNUM_MPLS_TP_PSEUDOWIRE_ENDPOINT_IDENTIFIER,     "MPLS-TP Pseudowire Endpoint Identifier"},
	{ AFNUM_MT_IP_MULTI_TOPOLOGY_IP_VERSION_4,          "MT IP: Multi-Topology IP version 4"},
	{ AFNUM_MT_IPV6_MULTI_TOPOLOGY_IP_VERSION_6,        "MT IPv6: Multi-Topology IP version 6"},
	{ AFNUM_BGP_SFC,                                    "BGP SFC"},
	{ AFNUM_EIGRP_COMMON_SERVICE_FAMILY,                "EIGRP Common Service Family"},
	{ AFNUM_EIGRP_IPV4_SERVICE_FAMILY,                  "EIGRP IPv4 Service Family"},
	{ AFNUM_EIGRP_IPV6_SERVICE_FAMILY,                  "EIGRP IPv6 Service Family"},
	{ AFNUM_LISP_CANONICAL_ADDRESS_FORMAT,              "LISP Canonical Address Format (LCAF)"},
	{ AFNUM_BGP_LS,                                     "BGP-LS"},
	{ AFNUM_48_BIT_MAC,                                 "48-bit MAC"},
	{ AFNUM_64_BIT_MAC,                                 "64-bit MAC"},
	{ AFNUM_OUI,                                        "OUI"},
	{ AFNUM_MAC_24,                                     "MAC/24"},
	{ AFNUM_MAC_40,                                     "MAC/40"},
	{ AFNUM_IPV6_64,                                    "IPv6/64"},
	{ AFNUM_RBRIDGE_PORT_ID,                            "RBridge Port ID"},
	{ AFNUM_TRILL_NICKNAME,                             "TRILL Nickname"},
	{ AFNUM_UNIVERSALLY_UNIQUE_IDENTIFIER,              "Universally Unique Identifier (UUID)"},
	{ AFNUM_ROUTING_POLICY_AFI,                         "Routing Policy AFI"},
	{ AFNUM_MPLS_NAMESPACES,                            "MPLS Namespaces"},
	{ AFNUM_RESERVED_65535,                             "Reserved"},
	{ 0, NULL },
};


static const value_string ipproto_val[] = {
	{ IP_PROTO_HOPOPT,                   "HOPOPT" },          /* 0 IPv6 Hop-by-Hop Option */
	{ IP_PROTO_ICMP,                     "ICMP" },            /* 1 Internet Control Message */
	{ IP_PROTO_IGMP,                     "IGMP" },            /* 2 Internet Group Management */
	{ IP_PROTO_GGP,                      "GGP" },             /* 3 Gateway-to-Gateway */
	{ IP_PROTO_IPV4,                     "IPv4" },            /* 4 IPv4 encapsulation */
	{ IP_PROTO_ST,                       "ST" },              /* 5 Stream */
	{ IP_PROTO_TCP,                      "TCP" },             /* 6 Transmission Control */
	{ IP_PROTO_CBT,                      "CBT" },             /* 7 CBT */
	{ IP_PROTO_EGP,                      "EGP" },             /* 8 Exterior Gateway Protocol */
	{ IP_PROTO_IGP,                      "IGP" },             /* 9 any private interior gateway             (used by Cisco for their IGRP) */
	{ IP_PROTO_BBN_RCC_MON,              "BBN-RCC-MON" },     /* 10 BBN RCC Monitoring */
	{ IP_PROTO_NVP_II,                   "NVP-II" },          /* 11 Network Voice Protocol */
	{ IP_PROTO_PUP,                      "PUP" },             /* 12 PUP */
	{ IP_PROTO_ARGUS_DEPRECATED,         "ARGUS (deprecated)" }, /* 13 ARGUS */
	{ IP_PROTO_EMCON,                    "EMCON" },           /* 14 EMCON */
	{ IP_PROTO_XNET,                     "XNET" },            /* 15 Cross Net Debugger */
	{ IP_PROTO_CHAOS,                    "CHAOS" },           /* 16 Chaos */
	{ IP_PROTO_UDP,                      "UDP" },             /* 17 User Datagram */
	{ IP_PROTO_MUX,                      "MUX" },             /* 18 Multiplexing */
	{ IP_PROTO_DCN_MEAS,                 "DCN-MEAS" },        /* 19 DCN Measurement Subsystems */
	{ IP_PROTO_HMP,                      "HMP" },             /* 20 Host Monitoring */
	{ IP_PROTO_PRM,                      "PRM" },             /* 21 Packet Radio Measurement */
	{ IP_PROTO_XNS_IDP,                  "XNS-IDP" },         /* 22 XEROX NS IDP */
	{ IP_PROTO_TRUNK_1,                  "TRUNK-1" },         /* 23 Trunk-1 */
	{ IP_PROTO_TRUNK_2,                  "TRUNK-2" },         /* 24 Trunk-2 */
	{ IP_PROTO_LEAF_1,                   "LEAF-1" },          /* 25 Leaf-1 */
	{ IP_PROTO_LEAF_2,                   "LEAF-2" },          /* 26 Leaf-2 */
	{ IP_PROTO_RDP,                      "RDP" },             /* 27 Reliable Data Protocol */
	{ IP_PROTO_IRTP,                     "IRTP" },            /* 28 Internet Reliable Transaction */
	{ IP_PROTO_ISO_TP4,                  "ISO-TP4" },         /* 29 ISO Transport Protocol Class 4 */
	{ IP_PROTO_NETBLT,                   "NETBLT" },          /* 30 Bulk Data Transfer Protocol */
	{ IP_PROTO_MFE_NSP,                  "MFE-NSP" },         /* 31 MFE Network Services Protocol */
	{ IP_PROTO_MERIT_INP,                "MERIT-INP" },       /* 32 MERIT Internodal Protocol */
	{ IP_PROTO_DCCP,                     "DCCP" },            /* 33 Datagram Congestion Control Protocol */
	{ IP_PROTO_3PC,                      "3PC" },             /* 34 Third Party Connect Protocol */
	{ IP_PROTO_IDPR,                     "IDPR" },            /* 35 Inter-Domain Policy Routing Protocol */
	{ IP_PROTO_XTP,                      "XTP" },             /* 36 XTP */
	{ IP_PROTO_DDP,                      "DDP" },             /* 37 Datagram Delivery Protocol */
	{ IP_PROTO_IDPR_CMTP,                "IDPR-CMTP" },       /* 38 IDPR Control Message Transport Proto */
	{ IP_PROTO_TP,                       "TP++" },            /* 39 TP++ Transport Protocol */
	{ IP_PROTO_IL,                       "IL" },              /* 40 IL Transport Protocol */
	{ IP_PROTO_IPV6,                     "IPv6" },            /* 41 IPv6 encapsulation */
	{ IP_PROTO_SDRP,                     "SDRP" },            /* 42 Source Demand Routing Protocol */
	{ IP_PROTO_IPV6_ROUTE,               "IPv6-Route" },      /* 43 Routing Header for IPv6 */
	{ IP_PROTO_IPV6_FRAG,                "IPv6-Frag" },       /* 44 Fragment Header for IPv6 */
	{ IP_PROTO_IDRP,                     "IDRP" },            /* 45 Inter-Domain Routing Protocol */
	{ IP_PROTO_RSVP,                     "RSVP" },            /* 46 Reservation Protocol */
	{ IP_PROTO_GRE,                      "GRE" },             /* 47 Generic Routing Encapsulation */
	{ IP_PROTO_DSR,                      "DSR" },             /* 48 Dynamic Source Routing Protocol */
	{ IP_PROTO_BNA,                      "BNA" },             /* 49 BNA */
	{ IP_PROTO_ESP,                      "ESP" },             /* 50 Encap Security Payload */
	{ IP_PROTO_AH,                       "AH" },              /* 51 Authentication Header */
	{ IP_PROTO_I_NLSP,                   "I-NLSP" },          /* 52 Integrated Net Layer Security  TUBA */
	{ IP_PROTO_SWIPE_DEPRECATED,         "SWIPE (deprecated)" }, /* 53 IP with Encryption */
	{ IP_PROTO_NARP,                     "NARP" },            /* 54 NBMA Address Resolution Protocol */
	{ IP_PROTO_MIN_IPV4,                 "Min-IPv4" },        /* 55 Minimal IPv4 Encapsulation */
	{ IP_PROTO_TLSP,                     "TLSP" },            /* 56 Transport Layer Security Protocol        using Kryptonet key management */
	{ IP_PROTO_SKIP,                     "SKIP" },            /* 57 SKIP */
	{ IP_PROTO_IPV6_ICMP,                "IPv6-ICMP" },       /* 58 ICMP for IPv6 */
	{ IP_PROTO_IPV6_NONXT,               "IPv6-NoNxt" },      /* 59 No Next Header for IPv6 */
	{ IP_PROTO_IPV6_OPTS,                "IPv6-Opts" },       /* 60 Destination Options for IPv6 */
	{ IP_PROTO_CFTP,                     "CFTP" },            /* 62 CFTP */
	{ IP_PROTO_SAT_EXPAK,                "SAT-EXPAK" },       /* 64 SATNET and Backroom EXPAK */
	{ IP_PROTO_KRYPTOLAN,                "KRYPTOLAN" },       /* 65 Kryptolan */
	{ IP_PROTO_RVD,                      "RVD" },             /* 66 MIT Remote Virtual Disk Protocol */
	{ IP_PROTO_IPPC,                     "IPPC" },            /* 67 Internet Pluribus Packet Core */
	{ IP_PROTO_SAT_MON,                  "SAT-MON" },         /* 69 SATNET Monitoring */
	{ IP_PROTO_VISA,                     "VISA" },            /* 70 VISA Protocol */
	{ IP_PROTO_IPCV,                     "IPCV" },            /* 71 Internet Packet Core Utility */
	{ IP_PROTO_CPNX,                     "CPNX" },            /* 72 Computer Protocol Network Executive */
	{ IP_PROTO_CPHB,                     "CPHB" },            /* 73 Computer Protocol Heart Beat */
	{ IP_PROTO_WSN,                      "WSN" },             /* 74 Wang Span Network */
	{ IP_PROTO_PVP,                      "PVP" },             /* 75 Packet Video Protocol */
	{ IP_PROTO_BR_SAT_MON,               "BR-SAT-MON" },      /* 76 Backroom SATNET Monitoring */
	{ IP_PROTO_SUN_ND,                   "SUN-ND" },          /* 77 SUN ND PROTOCOL-Temporary */
	{ IP_PROTO_WB_MON,                   "WB-MON" },          /* 78 WIDEBAND Monitoring */
	{ IP_PROTO_WB_EXPAK,                 "WB-EXPAK" },        /* 79 WIDEBAND EXPAK */
	{ IP_PROTO_ISO_IP,                   "ISO-IP" },          /* 80 ISO Internet Protocol */
	{ IP_PROTO_VMTP,                     "VMTP" },            /* 81 VMTP */
	{ IP_PROTO_SECURE_VMTP,              "SECURE-VMTP" },     /* 82 SECURE-VMTP */
	{ IP_PROTO_VINES,                    "VINES" },           /* 83 VINES */
	{ IP_PROTO_IPTM,                     "IPTM" },            /* 84 Internet Protocol Traffic Manager */
	{ IP_PROTO_NSFNET_IGP,               "NSFNET-IGP" },      /* 85 NSFNET-IGP */
	{ IP_PROTO_DGP,                      "DGP" },             /* 86 Dissimilar Gateway Protocol */
	{ IP_PROTO_TCF,                      "TCF" },             /* 87 TCF */
	{ IP_PROTO_EIGRP,                    "EIGRP" },           /* 88 EIGRP */
	{ IP_PROTO_OSPFIGP,                  "OSPFIGP" },         /* 89 OSPFIGP */
	{ IP_PROTO_SPRITE_RPC,               "Sprite-RPC" },      /* 90 Sprite RPC Protocol */
	{ IP_PROTO_LARP,                     "LARP" },            /* 91 Locus Address Resolution Protocol */
	{ IP_PROTO_MTP,                      "MTP" },             /* 92 Multicast Transport Protocol */
	{ IP_PROTO_AX25,                     "AX.25" },           /* 93 AX.25 Frames */
	{ IP_PROTO_IPIP,                     "IPIP" },            /* 94 IP-within-IP Encapsulation Protocol */
	{ IP_PROTO_MICP_DEPRECATED,          "MICP (deprecated)" }, /* 95 Mobile Internetworking Control Pro. */
	{ IP_PROTO_SCC_SP,                   "SCC-SP" },          /* 96 Semaphore Communications Sec. Pro. */
	{ IP_PROTO_ETHERIP,                  "ETHERIP" },         /* 97 Ethernet-within-IP Encapsulation */
	{ IP_PROTO_ENCAP,                    "ENCAP" },           /* 98 Encapsulation Header */
	{ IP_PROTO_GMTP,                     "GMTP" },            /* 100 GMTP */
	{ IP_PROTO_IFMP,                     "IFMP" },            /* 101 Ipsilon Flow Management Protocol */
	{ IP_PROTO_PNNI,                     "PNNI" },            /* 102 PNNI over IP */
	{ IP_PROTO_PIM,                      "PIM" },             /* 103 Protocol Independent Multicast */
	{ IP_PROTO_ARIS,                     "ARIS" },            /* 104 ARIS */
	{ IP_PROTO_SCPS,                     "SCPS" },            /* 105 SCPS */
	{ IP_PROTO_QNX,                      "QNX" },             /* 106 QNX */
	{ IP_PROTO_A_N,                      "A/N" },             /* 107 Active Networks */
	{ IP_PROTO_IPCOMP,                   "IPComp" },          /* 108 IP Payload Compression Protocol */
	{ IP_PROTO_SNP,                      "SNP" },             /* 109 Sitara Networks Protocol */
	{ IP_PROTO_COMPAQ_PEER,              "Compaq-Peer" },     /* 110 Compaq Peer Protocol */
	{ IP_PROTO_IPX_IN_IP,                "IPX-in-IP" },       /* 111 IPX in IP */
	{ IP_PROTO_VRRP,                     "VRRP" },            /* 112 Virtual Router Redundancy Protocol */
	{ IP_PROTO_PGM,                      "PGM" },             /* 113 PGM Reliable Transport Protocol */
	{ IP_PROTO_L2TP,                     "L2TP" },            /* 115 Layer Two Tunneling Protocol */
	{ IP_PROTO_DDX,                      "DDX" },             /* 116 D-II Data Exchange (DDX) */
	{ IP_PROTO_IATP,                     "IATP" },            /* 117 Interactive Agent Transfer Protocol */
	{ IP_PROTO_STP,                      "STP" },             /* 118 Schedule Transfer Protocol */
	{ IP_PROTO_SRP,                      "SRP" },             /* 119 SpectraLink Radio Protocol */
	{ IP_PROTO_UTI,                      "UTI" },             /* 120 UTI */
	{ IP_PROTO_SMP,                      "SMP" },             /* 121 Simple Message Protocol */
	{ IP_PROTO_SM_DEPRECATED,            "SM (deprecated)" }, /* 122 Simple Multicast Protocol */
	{ IP_PROTO_PTP,                      "PTP" },             /* 123 Performance Transparency Protocol */
	{ IP_PROTO_ISIS_OVER_IPV4,           "ISIS over IPv4" },  /* 124  */
	{ IP_PROTO_FIRE,                     "FIRE" },            /* 125  */
	{ IP_PROTO_CRTP,                     "CRTP" },            /* 126 Combat Radio Transport Protocol */
	{ IP_PROTO_CRUDP,                    "CRUDP" },           /* 127 Combat Radio User Datagram */
	{ IP_PROTO_SSCOPMCE,                 "SSCOPMCE" },        /* 128  */
	{ IP_PROTO_IPLT,                     "IPLT" },            /* 129  */
	{ IP_PROTO_SPS,                      "SPS" },             /* 130 Secure Packet Shield */
	{ IP_PROTO_PIPE,                     "PIPE" },            /* 131 Private IP Encapsulation within IP */
	{ IP_PROTO_SCTP,                     "SCTP" },            /* 132 Stream Control Transmission Protocol */
	{ IP_PROTO_FC,                       "FC" },              /* 133 Fibre Channel */
	{ IP_PROTO_RSVP_E2E_IGNORE,          "RSVP-E2E-IGNORE" }, /* 134  */
	{ IP_PROTO_MOBILITY_HEADER,          "Mobility Header" }, /* 135  */
	{ IP_PROTO_UDPLITE,                  "UDPLite" },         /* 136  */
	{ IP_PROTO_MPLS_IN_IP,               "MPLS-in-IP" },      /* 137  */
	{ IP_PROTO_MANET,                    "manet" },           /* 138 MANET Protocols */
	{ IP_PROTO_HIP,                      "HIP" },             /* 139 Host Identity Protocol */
	{ IP_PROTO_SHIM6,                    "Shim6" },           /* 140 Shim6 Protocol */
	{ IP_PROTO_WESP,                     "WESP" },            /* 141 Wrapped Encapsulating Security Payload */
	{ IP_PROTO_ROHC,                     "ROHC" },            /* 142 Robust Header Compression */
	{ IP_PROTO_ETHERNET,                 "Ethernet" },        /* 143 Ethernet */
	{ IP_PROTO_AGGFRAG,                  "AGGFRAG" },         /* 144 AGGFRAG encapsulation payload for ESP */
	{ IP_PROTO_NSH,                      "NSH" },             /* 145 Network Service Header */
	{ IP_PROTO_HOMA,                     "Homa" },            /* 146 Homa */
	{ IP_PROTO_BIT_EMU,                  "BIT-EMU" },         /* 147 Bit-stream Emulation */
	{ 148,                               "Unassigned" },      /* 148 Unassigned */
	{ 149,                               "Unassigned" },      /* 149 Unassigned */
	{ 150,                               "Unassigned" },      /* 150 Unassigned */
	{ 151,                               "Unassigned" },      /* 151 Unassigned */
	{ 152,                               "Unassigned" },      /* 152 Unassigned */
	{ 153,                               "Unassigned" },      /* 153 Unassigned */
	{ 154,                               "Unassigned" },      /* 154 Unassigned */
	{ 155,                               "Unassigned" },      /* 155 Unassigned */
	{ 156,                               "Unassigned" },      /* 156 Unassigned */
	{ 157,                               "Unassigned" },      /* 157 Unassigned */
	{ 158,                               "Unassigned" },      /* 158 Unassigned */
	{ 159,                               "Unassigned" },      /* 159 Unassigned */
	{ 160,                               "Unassigned" },      /* 160 Unassigned */
	{ 161,                               "Unassigned" },      /* 161 Unassigned */
	{ 162,                               "Unassigned" },      /* 162 Unassigned */
	{ 163,                               "Unassigned" },      /* 163 Unassigned */
	{ 164,                               "Unassigned" },      /* 164 Unassigned */
	{ 165,                               "Unassigned" },      /* 165 Unassigned */
	{ 166,                               "Unassigned" },      /* 166 Unassigned */
	{ 167,                               "Unassigned" },      /* 167 Unassigned */
	{ 168,                               "Unassigned" },      /* 168 Unassigned */
	{ 169,                               "Unassigned" },      /* 169 Unassigned */
	{ 170,                               "Unassigned" },      /* 170 Unassigned */
	{ 171,                               "Unassigned" },      /* 171 Unassigned */
	{ 172,                               "Unassigned" },      /* 172 Unassigned */
	{ 173,                               "Unassigned" },      /* 173 Unassigned */
	{ 174,                               "Unassigned" },      /* 174 Unassigned */
	{ 175,                               "Unassigned" },      /* 175 Unassigned */
	{ 176,                               "Unassigned" },      /* 176 Unassigned */
	{ 177,                               "Unassigned" },      /* 177 Unassigned */
	{ 178,                               "Unassigned" },      /* 178 Unassigned */
	{ 179,                               "Unassigned" },      /* 179 Unassigned */
	{ 180,                               "Unassigned" },      /* 180 Unassigned */
	{ 181,                               "Unassigned" },      /* 181 Unassigned */
	{ 182,                               "Unassigned" },      /* 182 Unassigned */
	{ 183,                               "Unassigned" },      /* 183 Unassigned */
	{ 184,                               "Unassigned" },      /* 184 Unassigned */
	{ 185,                               "Unassigned" },      /* 185 Unassigned */
	{ 186,                               "Unassigned" },      /* 186 Unassigned */
	{ 187,                               "Unassigned" },      /* 187 Unassigned */
	{ 188,                               "Unassigned" },      /* 188 Unassigned */
	{ 189,                               "Unassigned" },      /* 189 Unassigned */
	{ 190,                               "Unassigned" },      /* 190 Unassigned */
	{ 191,                               "Unassigned" },      /* 191 Unassigned */
	{ 192,                               "Unassigned" },      /* 192 Unassigned */
	{ 193,                               "Unassigned" },      /* 193 Unassigned */
	{ 194,                               "Unassigned" },      /* 194 Unassigned */
	{ 195,                               "Unassigned" },      /* 195 Unassigned */
	{ 196,                               "Unassigned" },      /* 196 Unassigned */
	{ 197,                               "Unassigned" },      /* 197 Unassigned */
	{ 198,                               "Unassigned" },      /* 198 Unassigned */
	{ 199,                               "Unassigned" },      /* 199 Unassigned */
	{ 200,                               "Unassigned" },      /* 200 Unassigned */
	{ 201,                               "Unassigned" },      /* 201 Unassigned */
	{ 202,                               "Unassigned" },      /* 202 Unassigned */
	{ 203,                               "Unassigned" },      /* 203 Unassigned */
	{ 204,                               "Unassigned" },      /* 204 Unassigned */
	{ 205,                               "Unassigned" },      /* 205 Unassigned */
	{ 206,                               "Unassigned" },      /* 206 Unassigned */
	{ 207,                               "Unassigned" },      /* 207 Unassigned */
	{ 208,                               "Unassigned" },      /* 208 Unassigned */
	{ 209,                               "Unassigned" },      /* 209 Unassigned */
	{ 210,                               "Unassigned" },      /* 210 Unassigned */
	{ 211,                               "Unassigned" },      /* 211 Unassigned */
	{ 212,                               "Unassigned" },      /* 212 Unassigned */
	{ 213,                               "Unassigned" },      /* 213 Unassigned */
	{ 214,                               "Unassigned" },      /* 214 Unassigned */
	{ 215,                               "Unassigned" },      /* 215 Unassigned */
	{ 216,                               "Unassigned" },      /* 216 Unassigned */
	{ 217,                               "Unassigned" },      /* 217 Unassigned */
	{ 218,                               "Unassigned" },      /* 218 Unassigned */
	{ 219,                               "Unassigned" },      /* 219 Unassigned */
	{ 220,                               "Unassigned" },      /* 220 Unassigned */
	{ 221,                               "Unassigned" },      /* 221 Unassigned */
	{ 222,                               "Unassigned" },      /* 222 Unassigned */
	{ 223,                               "Unassigned" },      /* 223 Unassigned */
	{ 224,                               "Unassigned" },      /* 224 Unassigned */
	{ 225,                               "Unassigned" },      /* 225 Unassigned */
	{ 226,                               "Unassigned" },      /* 226 Unassigned */
	{ 227,                               "Unassigned" },      /* 227 Unassigned */
	{ 228,                               "Unassigned" },      /* 228 Unassigned */
	{ 229,                               "Unassigned" },      /* 229 Unassigned */
	{ 230,                               "Unassigned" },      /* 230 Unassigned */
	{ 231,                               "Unassigned" },      /* 231 Unassigned */
	{ 232,                               "Unassigned" },      /* 232 Unassigned */
	{ 233,                               "Unassigned" },      /* 233 Unassigned */
	{ 234,                               "Unassigned" },      /* 234 Unassigned */
	{ 235,                               "Unassigned" },      /* 235 Unassigned */
	{ 236,                               "Unassigned" },      /* 236 Unassigned */
	{ 237,                               "Unassigned" },      /* 237 Unassigned */
	{ 238,                               "Unassigned" },      /* 238 Unassigned */
	{ 239,                               "Unassigned" },      /* 239 Unassigned */
	{ 240,                               "Unassigned" },      /* 240 Unassigned */
	{ 241,                               "Unassigned" },      /* 241 Unassigned */
	{ 242,                               "Unassigned" },      /* 242 Unassigned */
	{ 243,                               "Unassigned" },      /* 243 Unassigned */
	{ 244,                               "Unassigned" },      /* 244 Unassigned */
	{ 245,                               "Unassigned" },      /* 245 Unassigned */
	{ 246,                               "Unassigned" },      /* 246 Unassigned */
	{ 247,                               "Unassigned" },      /* 247 Unassigned */
	{ 248,                               "Unassigned" },      /* 248 Unassigned */
	{ 249,                               "Unassigned" },      /* 249 Unassigned */
	{ 250,                               "Unassigned" },      /* 250 Unassigned */
	{ 251,                               "Unassigned" },      /* 251 Unassigned */
	{ 252,                               "Unassigned" },      /* 252 Unassigned */
	{ IP_PROTO_RESERVED,                 "Reserved" },        /* 255  */
	{ 0, NULL },
};

value_string_ext ipproto_val_ext = VALUE_STRING_EXT_INIT(ipproto_val);
