/*
 * data-midi-sysex-id.c
 *
 * This file was generated by running tools\make-midi-sysex.py .
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <wsutil/value_string.h>
#include <data-midi-sysex-id.h>

/* One-byte MIDI SysEx Identifiers. */
static const value_string midi_sysex_id_vals[] = {
    {MIDI_SYSEX_ID_INDICATOR_FOR_EXTENDED_MIDI_SYSEX_ID,                    "Indicator for extended MIDI SysEx ID"},
    {MIDI_SYSEX_ID_SEQUENTIAL_CIRCUITS,                                     "Sequential Circuits"},
    {MIDI_SYSEX_ID_IDP,                                                     "IDP"},
    {MIDI_SYSEX_ID_VOYETRA_TURTLE_BEACH_INC,                                "Voyetra Turtle Beach, Inc."},
    {MIDI_SYSEX_ID_MOOG_MUSIC,                                              "Moog Music"},
    {MIDI_SYSEX_ID_PASSPORT_DESIGNS,                                        "Passport Designs"},
    {MIDI_SYSEX_ID_LEXICON_INC,                                             "Lexicon Inc."},
    {MIDI_SYSEX_ID_KURZWEIL_YOUNG_CHANG,                                    "Kurzweil / Young Chang"},
    {MIDI_SYSEX_ID_FENDER,                                                  "Fender"},
    {MIDI_SYSEX_ID_MIDI9,                                                   "MIDI9"},
    {MIDI_SYSEX_ID_AKG_ACOUSTICS,                                           "AKG Acoustics"},
    {MIDI_SYSEX_ID_VOYCE_MUSIC,                                             "Voyce Music"},
    {MIDI_SYSEX_ID_WAVEFRAME_TIMELINE,                                      "WaveFrame (Timeline)"},
    {MIDI_SYSEX_ID_ADA_SIGNAL_PROCESSORS_INC,                               "ADA Signal Processors, Inc."},
    {MIDI_SYSEX_ID_GARFIELD_ELECTRONICS,                                    "Garfield Electronics"},
    {MIDI_SYSEX_ID_ENSONIQ,                                                 "Ensoniq"},
    {MIDI_SYSEX_ID_OBERHEIM,                                                "Oberheim"},
    {MIDI_SYSEX_ID_APPLE,                                                   "Apple"},
    {MIDI_SYSEX_ID_GREY_MATTER_RESPONSE,                                    "Grey Matter Response"},
    {MIDI_SYSEX_ID_DIGIDESIGN_INC,                                          "Digidesign Inc."},
    {MIDI_SYSEX_ID_PALMTREE_INSTRUMENTS,                                    "Palmtree Instruments"},
    {MIDI_SYSEX_ID_JLCOOPER_ELECTRONICS,                                    "JLCooper Electronics"},
    {MIDI_SYSEX_ID_LOWREY_ORGAN_COMPANY,                                    "Lowrey Organ Company"},
    {MIDI_SYSEX_ID_ADAMS_SMITH,                                             "Adams-Smith"},
    {MIDI_SYSEX_ID_E_MU,                                                    "E-mu"},
    {MIDI_SYSEX_ID_HARMONY_SYSTEMS,                                         "Harmony Systems"},
    {MIDI_SYSEX_ID_ART,                                                     "ART"},
    {MIDI_SYSEX_ID_BALDWIN,                                                 "Baldwin"},
    {MIDI_SYSEX_ID_EVENTIDE,                                                "Eventide"},
    {MIDI_SYSEX_ID_INVENTRONICS,                                            "Inventronics"},
    {MIDI_SYSEX_ID_KEY_CONCEPTS,                                            "Key Concepts"},
    {MIDI_SYSEX_ID_CLARITY,                                                 "Clarity"},
    {MIDI_SYSEX_ID_PASSAC,                                                  "Passac"},
    {MIDI_SYSEX_ID_PROEL_LABS_SIEL,                                         "Proel Labs (SIEL)"},
    {MIDI_SYSEX_ID_SYNTHAXE_UK,                                             "Synthaxe (UK)"},
    {MIDI_SYSEX_ID_STEPP,                                                   "Stepp"},
    {MIDI_SYSEX_ID_HOHNER,                                                  "Hohner"},
    {MIDI_SYSEX_ID_TWISTER,                                                 "Twister"},
    {MIDI_SYSEX_ID_KETRON_S_R_L,                                            "Ketron s.r.l."},
    {MIDI_SYSEX_ID_JELLINGHAUS_MS,                                          "Jellinghaus MS"},
    {MIDI_SYSEX_ID_SOUTHWORTH_MUSIC_SYSTEMS,                                "Southworth Music Systems"},
    {MIDI_SYSEX_ID_PPG_GERMANY,                                             "PPG (Germany)"},
    {MIDI_SYSEX_ID_CESYG_LTD,                                               "CESYG Ltd."},
    {MIDI_SYSEX_ID_SOLID_STATE_LOGIC_ORGAN_SYSTEMS,                         "Solid State Logic Organ Systems"},
    {MIDI_SYSEX_ID_AUDIO_VERITRIEB_P_STRUVEN,                               "Audio Veritrieb-P. Struven"},
    {MIDI_SYSEX_ID_NEVE,                                                    "Neve"},
    {MIDI_SYSEX_ID_SOUNDTRACS_LTD,                                          "Soundtracs Ltd."},
    {MIDI_SYSEX_ID_ELKA,                                                    "Elka"},
    {MIDI_SYSEX_ID_DYNACORD,                                                "Dynacord"},
    {MIDI_SYSEX_ID_VISCOUNT_INTERNATIONAL_SPA_INTERCONTINENTAL_ELECTRONICS, "Viscount International Spa (Intercontinental Electronics)"},
    {MIDI_SYSEX_ID_DRAWMER,                                                 "Drawmer"},
    {MIDI_SYSEX_ID_CLAVIA_DIGITAL_INSTRUMENTS,                              "Clavia Digital Instruments"},
    {MIDI_SYSEX_ID_AUDIO_ARCHITECTURE,                                      "Audio Architecture"},
    {MIDI_SYSEX_ID_GENERALMUSIC_CORP_SPA,                                   "Generalmusic Corp SpA"},
    {MIDI_SYSEX_ID_CHEETAH_MARKETING,                                       "Cheetah Marketing"},
    {MIDI_SYSEX_ID_C_T_M,                                                   "C.T.M."},
    {MIDI_SYSEX_ID_SIMMONS_UK,                                              "Simmons UK"},
    {MIDI_SYSEX_ID_SOUNDCRAFT_ELECTRONICS,                                  "Soundcraft Electronics"},
    {MIDI_SYSEX_ID_STEINBERG_MEDIA_TECHNOLOGIES_GMBH,                       "Steinberg Media Technologies GmbH"},
    {MIDI_SYSEX_ID_WERSI_GMBH,                                              "Wersi Gmbh"},
    {MIDI_SYSEX_ID_AVAB_NIETHAMMER_AB,                                      "AVAB Niethammer AB"},
    {MIDI_SYSEX_ID_DIGIGRAM,                                                "Digigram"},
    {MIDI_SYSEX_ID_WALDORF_ELECTRONICS_GMBH,                                "Waldorf Electronics GmbH"},
    {MIDI_SYSEX_ID_QUASIMIDI,                                               "Quasimidi"},
    {MIDI_SYSEX_ID_KAWAI_MUSICAL_INSTRUMENTS_MFG_CO_LTD,                    "Kawai Musical Instruments MFG. CO. Ltd"},
    {MIDI_SYSEX_ID_ROLAND_CORPORATION,                                      "Roland Corporation"},
    {MIDI_SYSEX_ID_KORG_INC,                                                "Korg Inc."},
    {MIDI_SYSEX_ID_YAMAHA_CORPORATION,                                      "Yamaha Corporation"},
    {MIDI_SYSEX_ID_CASIO_COMPUTER_CO_LTD,                                   "Casio Computer Co. Ltd"},
    {MIDI_SYSEX_ID_KAMIYA_STUDIO_CO_LTD,                                    "Kamiya Studio Co. Ltd"},
    {MIDI_SYSEX_ID_AKAI_ELECTRIC_CO_LTD,                                    "Akai Electric Co. Ltd."},
    {MIDI_SYSEX_ID_VICTOR_COMPANY_OF_JAPAN_LTD,                             "Victor Company of Japan, Ltd."},
    {MIDI_SYSEX_ID_FUJITSU_LIMITED,                                         "Fujitsu Limited"},
    {MIDI_SYSEX_ID_SONY_CORPORATION,                                        "Sony Corporation"},
    {MIDI_SYSEX_ID_TEAC_CORPORATION,                                        "Teac Corporation"},
    {MIDI_SYSEX_ID_MATSUSHITA_ELECTRIC_INDUSTRIAL_CO_LTD,                   "Matsushita Electric Industrial Co. , Ltd"},
    {MIDI_SYSEX_ID_FOSTEX_CORPORATION,                                      "Fostex Corporation"},
    {MIDI_SYSEX_ID_ZOOM_CORPORATION,                                        "Zoom Corporation"},
    {MIDI_SYSEX_ID_MATSUSHITA_COMMUNICATION_INDUSTRIAL_CO_LTD,              "Matsushita Communication Industrial Co., Ltd."},
    {MIDI_SYSEX_ID_SUZUKI_MUSICAL_INSTRUMENTS_MFG_CO_LTD,                   "Suzuki Musical Instruments MFG. Co., Ltd."},
    {MIDI_SYSEX_ID_FUJI_SOUND_CORPORATION_LTD,                              "Fuji Sound Corporation Ltd."},
    {MIDI_SYSEX_ID_ACOUSTIC_TECHNICAL_LABORATORY_INC,                       "Acoustic Technical Laboratory, Inc."},
    {MIDI_SYSEX_ID_FAITH_INC,                                               "Faith, Inc."},
    {MIDI_SYSEX_ID_INTERNET_CORPORATION,                                    "Internet Corporation"},
    {MIDI_SYSEX_ID_SEEKERS_CO_LTD,                                          "Seekers Co. Ltd."},
    {MIDI_SYSEX_ID_SD_CARD_ASSOCIATION,                                     "SD Card Association"},
    {MIDI_SYSEX_ID_EDUCATIONAL_NON_COMMERCIAL_USE,                          "Educational/Non-Commercial Use"},
    {MIDI_SYSEX_ID_NON_REAL_TIME_UNIVERSAL_SYSTEM_EXCLUSIVE,                "Non-Real Time Universal System Exclusive"},
    {MIDI_SYSEX_ID_REAL_TIME_UNIVERSAL_SYSTEM_EXCLUSIVE,                    "Real Time Universal System Exclusive"},
    {0,                                                                     NULL}
};
value_string_ext midi_sysex_id_vals_ext = VALUE_STRING_EXT_INIT(midi_sysex_id_vals);

/* Three-byte (extended) MIDI SysEx Identifiers. */
static const value_string midi_sysex_extended_id_vals[] = {
    {MIDI_SYSEX_ID_TIME_WARNER_INTERACTIVE,                                        "Time/Warner Interactive"},
    {MIDI_SYSEX_ID_ADVANCED_GRAVIS_COMP_TECH_LTD,                                  "Advanced Gravis Comp. Tech Ltd."},
    {MIDI_SYSEX_ID_MEDIA_VISION,                                                   "Media Vision"},
    {MIDI_SYSEX_ID_DORNES_RESEARCH_GROUP,                                          "Dornes Research Group"},
    {MIDI_SYSEX_ID_K_MUSE,                                                         "K-Muse"},
    {MIDI_SYSEX_ID_STYPHER,                                                        "Stypher"},
    {MIDI_SYSEX_ID_DIGITAL_MUSIC_CORP,                                             "Digital Music Corp."},
    {MIDI_SYSEX_ID_IOTA_SYSTEMS,                                                   "IOTA Systems"},
    {MIDI_SYSEX_ID_NEW_ENGLAND_DIGITAL,                                            "New England Digital"},
    {MIDI_SYSEX_ID_ARTISYN,                                                        "Artisyn"},
    {MIDI_SYSEX_ID_IVL_TECHNOLOGIES_LTD,                                           "IVL Technologies Ltd."},
    {MIDI_SYSEX_ID_SOUTHERN_MUSIC_SYSTEMS,                                         "Southern Music Systems"},
    {MIDI_SYSEX_ID_LAKE_BUTLER_SOUND_COMPANY,                                      "Lake Butler Sound Company"},
    {MIDI_SYSEX_ID_ALESIS_STUDIO_ELECTRONICS,                                      "Alesis Studio Electronics"},
    {MIDI_SYSEX_ID_SOUND_CREATION,                                                 "Sound Creation"},
    {MIDI_SYSEX_ID_DOD_ELECTRONICS_CORP,                                           "DOD Electronics Corp."},
    {MIDI_SYSEX_ID_STUDER_EDITECH,                                                 "Studer-Editech"},
    {MIDI_SYSEX_ID_SONUS,                                                          "Sonus"},
    {MIDI_SYSEX_ID_TEMPORAL_ACUITY_PRODUCTS,                                       "Temporal Acuity Products"},
    {MIDI_SYSEX_ID_PERFECT_FRETWORKS,                                              "Perfect Fretworks"},
    {MIDI_SYSEX_ID_KAT_INC,                                                        "KAT Inc."},
    {MIDI_SYSEX_ID_OPCODE_SYSTEMS,                                                 "Opcode Systems"},
    {MIDI_SYSEX_ID_RANE_CORPORATION,                                               "Rane Corporation"},
    {MIDI_SYSEX_ID_ANADI_ELECTRONIQUE,                                             "Anadi Electronique"},
    {MIDI_SYSEX_ID_KMX,                                                            "KMX"},
    {MIDI_SYSEX_ID_ALLEN_HEATH_BRENELL,                                            "Allen & Heath Brenell"},
    {MIDI_SYSEX_ID_PEAVEY_ELECTRONICS,                                             "Peavey Electronics"},
    {MIDI_SYSEX_ID_360_SYSTEMS,                                                    "360 Systems"},
    {MIDI_SYSEX_ID_SPECTRUM_DESIGN_AND_DEVELOPMENT,                                "Spectrum Design and Development"},
    {MIDI_SYSEX_ID_MARQUIS_MUSIC,                                                  "Marquis Music"},
    {MIDI_SYSEX_ID_ZETA_SYSTEMS,                                                   "Zeta Systems"},
    {MIDI_SYSEX_ID_AXXES_BRIAN_PARSONETT,                                          "Axxes (Brian Parsonett)"},
    {MIDI_SYSEX_ID_ORBAN,                                                          "Orban"},
    {MIDI_SYSEX_ID_INDIAN_VALLEY_MFG,                                              "Indian Valley Mfg."},
    {MIDI_SYSEX_ID_TRITON,                                                         "Triton"},
    {MIDI_SYSEX_ID_KTI,                                                            "KTI"},
    {MIDI_SYSEX_ID_BREAKAWAY_TECHNOLOGIES,                                         "Breakaway Technologies"},
    {MIDI_SYSEX_ID_LEPRECON_CAE_INC,                                               "Leprecon / CAE Inc."},
    {MIDI_SYSEX_ID_HARRISON_SYSTEMS_INC,                                           "Harrison Systems Inc."},
    {MIDI_SYSEX_ID_FUTURE_LAB_MARK_KUO,                                            "Future Lab/Mark Kuo"},
    {MIDI_SYSEX_ID_ROCKTRON_CORPORATION,                                           "Rocktron Corporation"},
    {MIDI_SYSEX_ID_PIANODISC_00002A,                                               "PianoDisc"},
    {MIDI_SYSEX_ID_CANNON_RESEARCH_GROUP,                                          "Cannon Research Group"},
    {MIDI_SYSEX_ID_RESERVED_00002C,                                                "Reserved"},
    {MIDI_SYSEX_ID_RODGERS_INSTRUMENT_LLC,                                         "Rodgers Instrument LLC"},
    {MIDI_SYSEX_ID_BLUE_SKY_LOGIC,                                                 "Blue Sky Logic"},
    {MIDI_SYSEX_ID_ENCORE_ELECTRONICS,                                             "Encore Electronics"},
    {MIDI_SYSEX_ID_UPTOWN,                                                         "Uptown"},
    {MIDI_SYSEX_ID_VOCE,                                                           "Voce"},
    {MIDI_SYSEX_ID_CTI_AUDIO_INC_MUSICALLY_INTEL_DEVS,                             "CTI Audio, Inc. (Musically Intel. Devs.)"},
    {MIDI_SYSEX_ID_S3_INCORPORATED,                                                "S3 Incorporated"},
    {MIDI_SYSEX_ID_BRODERBUND_RED_ORB,                                             "Broderbund / Red Orb"},
    {MIDI_SYSEX_ID_ALLEN_ORGAN_CO,                                                 "Allen Organ Co."},
    {MIDI_SYSEX_ID_RESERVED_000036,                                                "Reserved"},
    {MIDI_SYSEX_ID_MUSIC_QUEST,                                                    "Music Quest"},
    {MIDI_SYSEX_ID_APHEX,                                                          "Aphex"},
    {MIDI_SYSEX_ID_GALLIEN_KRUEGER,                                                "Gallien Krueger"},
    {MIDI_SYSEX_ID_IBM,                                                            "IBM"},
    {MIDI_SYSEX_ID_MARK_OF_THE_UNICORN,                                            "Mark Of The Unicorn"},
    {MIDI_SYSEX_ID_HOTZ_CORPORATION,                                               "Hotz Corporation"},
    {MIDI_SYSEX_ID_ETA_LIGHTING,                                                   "ETA Lighting"},
    {MIDI_SYSEX_ID_NSI_CORPORATION,                                                "NSI Corporation"},
    {MIDI_SYSEX_ID_AD_LIB_INC,                                                     "Ad Lib, Inc."},
    {MIDI_SYSEX_ID_RICHMOND_SOUND_DESIGN,                                          "Richmond Sound Design"},
    {MIDI_SYSEX_ID_MICROSOFT,                                                      "Microsoft"},
    {MIDI_SYSEX_ID_MINDSCAPE_SOFTWARE_TOOLWORKS,                                   "Mindscape (Software Toolworks)"},
    {MIDI_SYSEX_ID_RUSS_JONES_MARKETING_NICHE,                                     "Russ Jones Marketing / Niche"},
    {MIDI_SYSEX_ID_INTONE,                                                         "Intone"},
    {MIDI_SYSEX_ID_ADVANCED_REMOTE_TECHNOLOGIES,                                   "Advanced Remote Technologies"},
    {MIDI_SYSEX_ID_WHITE_INSTRUMENTS,                                              "White Instruments"},
    {MIDI_SYSEX_ID_GT_ELECTRONICS_GROOVE_TUBES,                                    "GT Electronics/Groove Tubes"},
    {MIDI_SYSEX_ID_PACIFIC_RESEARCH_ENGINEERING,                                   "Pacific Research & Engineering"},
    {MIDI_SYSEX_ID_TIMELINE_VISTA_INC,                                             "Timeline Vista, Inc."},
    {MIDI_SYSEX_ID_MESA_BOOGIE_LTD,                                                "Mesa Boogie Ltd."},
    {MIDI_SYSEX_ID_FSLI,                                                           "FSLI"},
    {MIDI_SYSEX_ID_SEQUOIA_DEVELOPMENT_GROUP,                                      "Sequoia Development Group"},
    {MIDI_SYSEX_ID_STUDIO_ELECTRONICS,                                             "Studio Electronics"},
    {MIDI_SYSEX_ID_EUPHONIX_INC,                                                   "Euphonix, Inc"},
    {MIDI_SYSEX_ID_INTERMIDI_INC,                                                  "InterMIDI, Inc."},
    {MIDI_SYSEX_ID_MIDI_SOLUTIONS_INC,                                             "MIDI Solutions Inc."},
    {MIDI_SYSEX_ID_3DO_COMPANY,                                                    "3DO Company"},
    {MIDI_SYSEX_ID_LIGHTWAVE_RESEARCH_HIGH_END_SYSTEMS,                            "Lightwave Research / High End Systems"},
    {MIDI_SYSEX_ID_MICRO_W_CORPORATION,                                            "Micro-W Corporation"},
    {MIDI_SYSEX_ID_SPECTRAL_SYNTHESIS_INC,                                         "Spectral Synthesis, Inc."},
    {MIDI_SYSEX_ID_LONE_WOLF,                                                      "Lone Wolf"},
    {MIDI_SYSEX_ID_STUDIO_TECHNOLOGIES_INC,                                        "Studio Technologies Inc."},
    {MIDI_SYSEX_ID_PETERSON_ELECTRO_MUSICAL_PRODUCT_INC,                           "Peterson Electro-Musical Product, Inc."},
    {MIDI_SYSEX_ID_ATARI_CORPORATION,                                              "Atari Corporation"},
    {MIDI_SYSEX_ID_MARION_SYSTEMS_CORPORATION,                                     "Marion Systems Corporation"},
    {MIDI_SYSEX_ID_DESIGN_EVENT,                                                   "Design Event"},
    {MIDI_SYSEX_ID_WINJAMMER_SOFTWARE_LTD,                                         "Winjammer Software Ltd."},
    {MIDI_SYSEX_ID_AT_T_BELL_LABORATORIES,                                         "AT&T Bell Laboratories"},
    {MIDI_SYSEX_ID_RESERVED_00005D,                                                "Reserved"},
    {MIDI_SYSEX_ID_SYMETRIX,                                                       "Symetrix"},
    {MIDI_SYSEX_ID_MIDI_THE_WORLD,                                                 "MIDI the World"},
    {MIDI_SYSEX_ID_SPATIALIZER,                                                    "Spatializer"},
    {MIDI_SYSEX_ID_MICROS_N_MIDI,                                                  "Micros \u2018N MIDI"},
    {MIDI_SYSEX_ID_ACCORDIANS_INTERNATIONAL,                                       "Accordians International"},
    {MIDI_SYSEX_ID_EUPHONICS_NOW_3COM,                                             "EuPhonics (now 3Com)"},
    {MIDI_SYSEX_ID_MUSONIX,                                                        "Musonix"},
    {MIDI_SYSEX_ID_TURTLE_BEACH_SYSTEMS_VOYETRA,                                   "Turtle Beach Systems (Voyetra)"},
    {MIDI_SYSEX_ID_LOUD_TECHNOLOGIES_MACKIE,                                       "Loud Technologies / Mackie"},
    {MIDI_SYSEX_ID_COMPUSERVE,                                                     "Compuserve"},
    {MIDI_SYSEX_ID_BEC_TECHNOLOGIES,                                               "BEC Technologies"},
    {MIDI_SYSEX_ID_QRS_MUSIC_INC,                                                  "QRS Music Inc"},
    {MIDI_SYSEX_ID_P_G_MUSIC,                                                      "P.G. Music"},
    {MIDI_SYSEX_ID_SIERRA_SEMICONDUCTOR,                                           "Sierra Semiconductor"},
    {MIDI_SYSEX_ID_EPIGRAF,                                                        "EpiGraf"},
    {MIDI_SYSEX_ID_ELECTRONICS_DIVERSIFIED_INC,                                    "Electronics Diversified Inc"},
    {MIDI_SYSEX_ID_TUNE_1000,                                                      "Tune 1000"},
    {MIDI_SYSEX_ID_ADVANCED_MICRO_DEVICES,                                         "Advanced Micro Devices"},
    {MIDI_SYSEX_ID_MEDIAMATION,                                                    "Mediamation"},
    {MIDI_SYSEX_ID_SABINE_MUSICAL_MFG_CO_INC,                                      "Sabine Musical Mfg. Co. Inc."},
    {MIDI_SYSEX_ID_WOOG_LABS,                                                      "Woog Labs"},
    {MIDI_SYSEX_ID_MICROPOLIS_CORP,                                                "Micropolis Corp"},
    {MIDI_SYSEX_ID_TA_HORNG_MUSICAL_INSTRUMENT,                                    "Ta Horng Musical Instrument"},
    {MIDI_SYSEX_ID_E_TEK_LABS_FORTE_TECH,                                          "e-Tek Labs (Forte Tech)"},
    {MIDI_SYSEX_ID_ELECTRO_VOICE,                                                  "Electro-Voice"},
    {MIDI_SYSEX_ID_MIDISOFT_CORPORATION,                                           "Midisoft Corporation"},
    {MIDI_SYSEX_ID_QSOUND_LABS,                                                    "QSound Labs"},
    {MIDI_SYSEX_ID_WESTREX,                                                        "Westrex"},
    {MIDI_SYSEX_ID_NVIDIA,                                                         "Nvidia"},
    {MIDI_SYSEX_ID_ESS_TECHNOLOGY,                                                 "ESS Technology"},
    {MIDI_SYSEX_ID_MEDIA_TRIX_PERIPHERALS,                                         "Media Trix Peripherals"},
    {MIDI_SYSEX_ID_BROOKTREE_CORP,                                                 "Brooktree Corp"},
    {MIDI_SYSEX_ID_OTARI_CORP,                                                     "Otari Corp"},
    {MIDI_SYSEX_ID_KEY_ELECTRONICS_INC,                                            "Key Electronics, Inc."},
    {MIDI_SYSEX_ID_SHURE_INCORPORATED,                                             "Shure Incorporated"},
    {MIDI_SYSEX_ID_AURASOUND,                                                      "AuraSound"},
    {MIDI_SYSEX_ID_CRYSTAL_SEMICONDUCTOR,                                          "Crystal Semiconductor"},
    {MIDI_SYSEX_ID_CONEXANT_ROCKWELL,                                              "Conexant (Rockwell)"},
    {MIDI_SYSEX_ID_SILICON_GRAPHICS,                                               "Silicon Graphics"},
    {MIDI_SYSEX_ID_M_AUDIO_MIDIMAN,                                                "M-Audio (Midiman)"},
    {MIDI_SYSEX_ID_PRESONUS,                                                       "PreSonus"},
    {MIDI_SYSEX_ID_TOPAZ_ENTERPRISES,                                              "Topaz Enterprises"},
    {MIDI_SYSEX_ID_CAST_LIGHTING,                                                  "Cast Lighting"},
    {MIDI_SYSEX_ID_MICROSOFT_CONSUMER_DIVISION,                                    "Microsoft Consumer Division"},
    {MIDI_SYSEX_ID_SONIC_FOUNDRY,                                                  "Sonic Foundry"},
    {MIDI_SYSEX_ID_LINE_6_FAST_FORWARD_YAMAHA,                                     "Line 6 (Fast Forward) (Yamaha)"},
    {MIDI_SYSEX_ID_BEATNIK_INC,                                                    "Beatnik Inc"},
    {MIDI_SYSEX_ID_VAN_KOEVERING_COMPANY,                                          "Van Koevering Company"},
    {MIDI_SYSEX_ID_ALTECH_SYSTEMS,                                                 "Altech Systems"},
    {MIDI_SYSEX_ID_S_S_RESEARCH,                                                   "S & S Research"},
    {MIDI_SYSEX_ID_VLSI_TECHNOLOGY,                                                "VLSI Technology"},
    {MIDI_SYSEX_ID_CHROMATIC_RESEARCH,                                             "Chromatic Research"},
    {MIDI_SYSEX_ID_SAPPHIRE,                                                       "Sapphire"},
    {MIDI_SYSEX_ID_IDRC,                                                           "IDRC"},
    {MIDI_SYSEX_ID_JUSTONIC_TUNING,                                                "Justonic Tuning"},
    {MIDI_SYSEX_ID_TORCOMP_RESEARCH_INC,                                           "TorComp Research Inc."},
    {MIDI_SYSEX_ID_NEWTEK_INC,                                                     "Newtek Inc."},
    {MIDI_SYSEX_ID_SOUND_SCULPTURE,                                                "Sound Sculpture"},
    {MIDI_SYSEX_ID_WALKER_TECHNICAL,                                               "Walker Technical"},
    {MIDI_SYSEX_ID_DIGITAL_HARMONY_PAVO,                                           "Digital Harmony (PAVO)"},
    {MIDI_SYSEX_ID_INVISION_INTERACTIVE,                                           "InVision Interactive"},
    {MIDI_SYSEX_ID_T_SQUARE_DESIGN,                                                "T-Square Design"},
    {MIDI_SYSEX_ID_NEMESYS_MUSIC_TECHNOLOGY,                                       "Nemesys Music Technology"},
    {MIDI_SYSEX_ID_DBX_PROFESSIONAL_HARMAN_INTL,                                   "DBX Professional (Harman Intl)"},
    {MIDI_SYSEX_ID_SYNDYNE_CORPORATION,                                            "Syndyne Corporation"},
    {MIDI_SYSEX_ID_BITHEADZ,                                                       "Bitheadz"},
    {MIDI_SYSEX_ID_BANDLAB_TECHNOLOGIES,                                           "BandLab Technologies"},
    {MIDI_SYSEX_ID_ANALOG_DEVICES,                                                 "Analog Devices"},
    {MIDI_SYSEX_ID_NATIONAL_SEMICONDUCTOR,                                         "National Semiconductor"},
    {MIDI_SYSEX_ID_BOOM_THEORY_ADINOLFI_ALTERNATIVE_PERCUSSION,                    "Boom Theory / Adinolfi Alternative Percussion"},
    {MIDI_SYSEX_ID_VIRTUAL_DSP_CORPORATION,                                        "Virtual DSP Corporation"},
    {MIDI_SYSEX_ID_ANTARES_SYSTEMS,                                                "Antares Systems"},
    {MIDI_SYSEX_ID_ANGEL_SOFTWARE,                                                 "Angel Software"},
    {MIDI_SYSEX_ID_ST_LOUIS_MUSIC,                                                 "St Louis Music"},
    {MIDI_SYSEX_ID_PASSPORT_MUSIC_SOFTWARE_LLC_GVOX,                               "Passport Music Software LLC (Gvox)"},
    {MIDI_SYSEX_ID_ASHLEY_AUDIO_INC,                                               "Ashley Audio Inc."},
    {MIDI_SYSEX_ID_VARI_LITE_INC,                                                  "Vari-Lite Inc."},
    {MIDI_SYSEX_ID_SUMMIT_AUDIO_INC,                                               "Summit Audio Inc."},
    {MIDI_SYSEX_ID_AUREAL_SEMICONDUCTOR_INC,                                       "Aureal Semiconductor Inc."},
    {MIDI_SYSEX_ID_SEASOUND_LLC,                                                   "SeaSound LLC"},
    {MIDI_SYSEX_ID_U_S_ROBOTICS,                                                   "U.S. Robotics"},
    {MIDI_SYSEX_ID_AURISIS_RESEARCH,                                               "Aurisis Research"},
    {MIDI_SYSEX_ID_NEARFIELD_RESEARCH,                                             "Nearfield Research"},
    {MIDI_SYSEX_ID_FM7_INC,                                                        "FM7 Inc"},
    {MIDI_SYSEX_ID_SWIVEL_SYSTEMS,                                                 "Swivel Systems"},
    {MIDI_SYSEX_ID_HYPERACTIVE_AUDIO_SYSTEMS,                                      "Hyperactive Audio Systems"},
    {MIDI_SYSEX_ID_MIDILITE_CASTLE_STUDIOS_PRODUCTIONS,                            "MidiLite (Castle Studios Productions)"},
    {MIDI_SYSEX_ID_RADIKAL_TECHNOLOGIES,                                           "Radikal Technologies"},
    {MIDI_SYSEX_ID_ROGER_LINN_DESIGN,                                              "Roger Linn Design"},
    {MIDI_SYSEX_ID_TC_HELICON_VOCAL_TECHNOLOGIES,                                  "TC-Helicon Vocal Technologies"},
    {MIDI_SYSEX_ID_EVENT_ELECTRONICS,                                              "Event Electronics"},
    {MIDI_SYSEX_ID_SONIC_NETWORK_INC,                                              "Sonic Network Inc"},
    {MIDI_SYSEX_ID_REALTIME_MUSIC_SOLUTIONS,                                       "Realtime Music Solutions"},
    {MIDI_SYSEX_ID_APOGEE_DIGITAL,                                                 "Apogee Digital"},
    {MIDI_SYSEX_ID_CLASSICAL_ORGANS_INC,                                           "Classical Organs, Inc."},
    {MIDI_SYSEX_ID_MICROTOOLS_INC,                                                 "Microtools Inc."},
    {MIDI_SYSEX_ID_NUMARK_INDUSTRIES,                                              "Numark Industries"},
    {MIDI_SYSEX_ID_FRONTIER_DESIGN_GROUP_LLC,                                      "Frontier Design Group, LLC"},
    {MIDI_SYSEX_ID_RECORDARE_LLC,                                                  "Recordare LLC"},
    {MIDI_SYSEX_ID_STARR_LABS,                                                     "Starr Labs"},
    {MIDI_SYSEX_ID_VOYAGER_SOUND_INC,                                              "Voyager Sound Inc."},
    {MIDI_SYSEX_ID_MANIFOLD_LABS,                                                  "Manifold Labs"},
    {MIDI_SYSEX_ID_AVIOM_INC,                                                      "Aviom Inc."},
    {MIDI_SYSEX_ID_MIXMEISTER_TECHNOLOGY,                                          "Mixmeister Technology"},
    {MIDI_SYSEX_ID_NOTATION_SOFTWARE,                                              "Notation Software"},
    {MIDI_SYSEX_ID_MERCURIAL_COMMUNICATIONS,                                       "Mercurial Communications"},
    {MIDI_SYSEX_ID_WAVE_ARTS,                                                      "Wave Arts"},
    {MIDI_SYSEX_ID_LOGIC_SEQUENCING_DEVICES,                                       "Logic Sequencing Devices"},
    {MIDI_SYSEX_ID_AXESS_ELECTRONICS,                                              "Axess Electronics"},
    {MIDI_SYSEX_ID_MUSE_RESEARCH,                                                  "Muse Research"},
    {MIDI_SYSEX_ID_OPEN_LABS,                                                      "Open Labs"},
    {MIDI_SYSEX_ID_GUILLEMOT_CORP,                                                 "Guillemot Corp"},
    {MIDI_SYSEX_ID_SAMSON_TECHNOLOGIES,                                            "Samson Technologies"},
    {MIDI_SYSEX_ID_ELECTRONIC_THEATRE_CONTROLS,                                    "Electronic Theatre Controls"},
    {MIDI_SYSEX_ID_BLACKBERRY_RIM,                                                 "Blackberry (RIM)"},
    {MIDI_SYSEX_ID_MOBILEER,                                                       "Mobileer"},
    {MIDI_SYSEX_ID_SYNTHOGY,                                                       "Synthogy"},
    {MIDI_SYSEX_ID_LYNX_STUDIO_TECHNOLOGY_INC,                                     "Lynx Studio Technology Inc."},
    {MIDI_SYSEX_ID_DAMAGE_CONTROL_ENGINEERING_LLC,                                 "Damage Control Engineering LLC"},
    {MIDI_SYSEX_ID_YOST_ENGINEERING_INC,                                           "Yost Engineering, Inc."},
    {MIDI_SYSEX_ID_BROOKS_FORSMAN_DESIGNS_LLC_DRUMLITE,                            "Brooks & Forsman Designs LLC / DrumLite"},
    {MIDI_SYSEX_ID_INFINITE_RESPONSE,                                              "Infinite Response"},
    {MIDI_SYSEX_ID_GARRITAN_CORP,                                                  "Garritan Corp"},
    {MIDI_SYSEX_ID_PLOGUE_ART_ET_TECHNOLOGIE_INC,                                  "Plogue Art et Technologie, Inc"},
    {MIDI_SYSEX_ID_RJM_MUSIC_TECHNOLOGY,                                           "RJM Music Technology"},
    {MIDI_SYSEX_ID_CUSTOM_SOLUTIONS_SOFTWARE,                                      "Custom Solutions Software"},
    {MIDI_SYSEX_ID_SONARCANA_LLC_HIGHLY_LIQUID,                                    "Sonarcana LLC / Highly Liquid"},
    {MIDI_SYSEX_ID_CENTRANCE,                                                      "Centrance"},
    {MIDI_SYSEX_ID_KESUMO_LLC,                                                     "Kesumo LLC"},
    {MIDI_SYSEX_ID_STANTON_GIBSON_BRANDS,                                          "Stanton (Gibson Brands)"},
    {MIDI_SYSEX_ID_LIVID_INSTRUMENTS,                                              "Livid Instruments"},
    {MIDI_SYSEX_ID_FIRST_ACT_745_MEDIA,                                            "First Act / 745 Media"},
    {MIDI_SYSEX_ID_PYGRAPHICS_INC,                                                 "Pygraphics, Inc."},
    {MIDI_SYSEX_ID_PANADIGM_INNOVATIONS_LTD,                                       "Panadigm Innovations Ltd"},
    {MIDI_SYSEX_ID_AVEDIS_ZILDJIAN_CO,                                             "Avedis Zildjian Co"},
    {MIDI_SYSEX_ID_AUVITAL_MUSIC_CORP,                                             "Auvital Music Corp"},
    {MIDI_SYSEX_ID_YOU_ROCK_GUITAR_WAS_INSPIRED_INSTRUMENTS,                       "You Rock Guitar (was: Inspired Instruments)"},
    {MIDI_SYSEX_ID_CHRIS_GRIGG_DESIGNS,                                            "Chris Grigg Designs"},
    {MIDI_SYSEX_ID_SLATE_DIGITAL_LLC,                                              "Slate Digital LLC"},
    {MIDI_SYSEX_ID_MIXWARE,                                                        "Mixware"},
    {MIDI_SYSEX_ID_SOCIAL_ENTROPY,                                                 "Social Entropy"},
    {MIDI_SYSEX_ID_SOURCE_AUDIO_LLC,                                               "Source Audio LLC"},
    {MIDI_SYSEX_ID_ERNIE_BALL_MUSIC_MAN,                                           "Ernie Ball / Music Man"},
    {MIDI_SYSEX_ID_FISHMAN,                                                        "Fishman"},
    {MIDI_SYSEX_ID_CUSTOM_AUDIO_ELECTRONICS,                                       "Custom Audio Electronics"},
    {MIDI_SYSEX_ID_AMERICAN_AUDIO_DJ,                                              "American Audio/DJ"},
    {MIDI_SYSEX_ID_MEGA_CONTROL_SYSTEMS,                                           "Mega Control Systems"},
    {MIDI_SYSEX_ID_KILPATRICK_AUDIO,                                               "Kilpatrick Audio"},
    {MIDI_SYSEX_ID_ICONNECTIVITY,                                                  "iConnectivity"},
    {MIDI_SYSEX_ID_FRACTAL_AUDIO,                                                  "Fractal Audio"},
    {MIDI_SYSEX_ID_NETLOGIC_MICROSYSTEMS,                                          "NetLogic Microsystems"},
    {MIDI_SYSEX_ID_MUSIC_COMPUTING,                                                "Music Computing"},
    {MIDI_SYSEX_ID_NEKTAR_TECHNOLOGY_INC,                                          "Nektar Technology Inc"},
    {MIDI_SYSEX_ID_ZENPH_SOUND_INNOVATIONS,                                        "Zenph Sound Innovations"},
    {MIDI_SYSEX_ID_DJTECHTOOLS_COM,                                                "DJTechTools.com"},
    {MIDI_SYSEX_ID_REZONANCE_LABS,                                                 "Rezonance Labs"},
    {MIDI_SYSEX_ID_DECIBEL_ELEVEN,                                                 "Decibel Eleven"},
    {MIDI_SYSEX_ID_CNMAT,                                                          "CNMAT"},
    {MIDI_SYSEX_ID_MEDIA_OVERKILL,                                                 "Media Overkill"},
    {MIDI_SYSEX_ID_CONFUSION_STUDIOS,                                              "Confusion Studios"},
    {MIDI_SYSEX_ID_MOFORTE_INC,                                                    "moForte Inc"},
    {MIDI_SYSEX_ID_MISELU_INC,                                                     "Miselu Inc"},
    {MIDI_SYSEX_ID_AMELIAS_COMPASS_LLC,                                            "Amelia\u2019s Compass LLC"},
    {MIDI_SYSEX_ID_ZIVIX_LLC,                                                      "Zivix LLC"},
    {MIDI_SYSEX_ID_ARTIPHON,                                                       "Artiphon"},
    {MIDI_SYSEX_ID_SYNCLAVIER_DIGITAL,                                             "Synclavier Digital"},
    {MIDI_SYSEX_ID_LIGHT_SOUND_CONTROL_DEVICES_LLC,                                "Light & Sound Control Devices LLC"},
    {MIDI_SYSEX_ID_RETRONYMS_INC,                                                  "Retronyms Inc"},
    {MIDI_SYSEX_ID_JS_TECHNOLOGIES,                                                "JS Technologies"},
    {MIDI_SYSEX_ID_QUICCO_SOUND,                                                   "Quicco Sound"},
    {MIDI_SYSEX_ID_A_DESIGNS_AUDIO,                                                "A-Designs Audio"},
    {MIDI_SYSEX_ID_MCCARTHY_MUSIC_CORP,                                            "McCarthy Music Corp"},
    {MIDI_SYSEX_ID_DENON_DJ,                                                       "Denon DJ"},
    {MIDI_SYSEX_ID_KEITH_ROBERT_MURRAY,                                            "Keith Robert Murray"},
    {MIDI_SYSEX_ID_GOOGLE,                                                         "Google"},
    {MIDI_SYSEX_ID_ISP_TECHNOLOGIES,                                               "ISP Technologies"},
    {MIDI_SYSEX_ID_ABSTRAKT_INSTRUMENTS_LLC,                                       "Abstrakt Instruments LLC"},
    {MIDI_SYSEX_ID_MERIS_LLC,                                                      "Meris LLC"},
    {MIDI_SYSEX_ID_SENSORPOINT_LLC,                                                "Sensorpoint LLC"},
    {MIDI_SYSEX_ID_HI_Z_LABS,                                                      "Hi-Z Labs"},
    {MIDI_SYSEX_ID_IMITONE,                                                        "Imitone"},
    {MIDI_SYSEX_ID_INTELLIJEL_DESIGNS_INC,                                         "Intellijel Designs Inc."},
    {MIDI_SYSEX_ID_DASZ_INSTRUMENTS_INC,                                           "Dasz Instruments Inc."},
    {MIDI_SYSEX_ID_REMIDI,                                                         "Remidi"},
    {MIDI_SYSEX_ID_DISASTER_AREA_DESIGNS_LLC,                                      "Disaster Area Designs LLC"},
    {MIDI_SYSEX_ID_UNIVERSAL_AUDIO,                                                "Universal Audio"},
    {MIDI_SYSEX_ID_CARTER_DUNCAN_CORP,                                             "Carter Duncan Corp"},
    {MIDI_SYSEX_ID_ESSENTIAL_TECHNOLOGY_00021A,                                    "Essential Technology"},
    {MIDI_SYSEX_ID_CANTUX_RESEARCH_LLC,                                            "Cantux Research LLC"},
    {MIDI_SYSEX_ID_HUMMEL_TECHNOLOGIES,                                            "Hummel Technologies"},
    {MIDI_SYSEX_ID_SENSEL_INC,                                                     "Sensel Inc"},
    {MIDI_SYSEX_ID_DBML_GROUP,                                                     "DBML Group"},
    {MIDI_SYSEX_ID_MADRONA_LABS,                                                   "Madrona Labs"},
    {MIDI_SYSEX_ID_MESA_BOOGIE,                                                    "Mesa Boogie"},
    {MIDI_SYSEX_ID_EFFIGY_LABS,                                                    "Effigy Labs"},
    {MIDI_SYSEX_ID_AMENOTE,                                                        "Amenote"},
    {MIDI_SYSEX_ID_RED_PANDA_LLC,                                                  "Red Panda LLC"},
    {MIDI_SYSEX_ID_ONSONG_LLC,                                                     "OnSong LLC"},
    {MIDI_SYSEX_ID_JAMBOXX_INC,                                                    "Jamboxx Inc."},
    {MIDI_SYSEX_ID_ELECTRO_HARMONIX,                                               "Electro-Harmonix"},
    {MIDI_SYSEX_ID_RND64_INC,                                                      "RnD64 Inc"},
    {MIDI_SYSEX_ID_NEUNABER_TECHNOLOGY_LLC,                                        "Neunaber Technology LLC"},
    {MIDI_SYSEX_ID_KAOM_INC,                                                       "Kaom Inc."},
    {MIDI_SYSEX_ID_HALLOWELL_EMC,                                                  "Hallowell EMC"},
    {MIDI_SYSEX_ID_SOUND_DEVICES_LLC,                                              "Sound Devices, LLC"},
    {MIDI_SYSEX_ID_SPECTRASONICS_INC,                                              "Spectrasonics, Inc"},
    {MIDI_SYSEX_ID_SECOND_SOUND_LLC,                                               "Second Sound, LLC"},
    {MIDI_SYSEX_ID_8EO_HORN,                                                       "8eo (Horn)"},
    {MIDI_SYSEX_ID_VIDVOX_LLC,                                                     "VIDVOX LLC"},
    {MIDI_SYSEX_ID_MATTHEWS_EFFECTS,                                               "Matthews Effects"},
    {MIDI_SYSEX_ID_BRIGHT_BLUE_BEETLE,                                             "Bright Blue Beetle"},
    {MIDI_SYSEX_ID_AUDIO_IMPRESSIONS,                                              "Audio Impressions"},
    {MIDI_SYSEX_ID_LOOPERLATIVE,                                                   "Looperlative"},
    {MIDI_SYSEX_ID_STEINWAY,                                                       "Steinway"},
    {MIDI_SYSEX_ID_INGENIOUS_ARTS_AND_TECHNOLOGIES_LLC,                            "Ingenious Arts and Technologies LLC"},
    {MIDI_SYSEX_ID_DCA_AUDIO,                                                      "DCA Audio"},
    {MIDI_SYSEX_ID_BUCHLA_USA,                                                     "Buchla USA"},
    {MIDI_SYSEX_ID_SINICON,                                                        "Sinicon"},
    {MIDI_SYSEX_ID_ISLA_INSTRUMENTS,                                               "Isla Instruments"},
    {MIDI_SYSEX_ID_SOUNDIRON_LLC,                                                  "Soundiron LLC"},
    {MIDI_SYSEX_ID_SONOCLAST_LLC,                                                  "Sonoclast, LLC"},
    {MIDI_SYSEX_ID_COPPER_AND_CEDAR,                                               "Copper and Cedar"},
    {MIDI_SYSEX_ID_WHIRLED_NOTES,                                                  "Whirled Notes"},
    {MIDI_SYSEX_ID_CEJETVOLE_LLC,                                                  "Cejetvole, LLC"},
    {MIDI_SYSEX_ID_DAWN_AUDIO_LLC,                                                 "DAWn Audio LLC"},
    {MIDI_SYSEX_ID_SPACE_BRAIN_CIRCUITS,                                           "Space Brain Circuits"},
    {MIDI_SYSEX_ID_CAEDENCE,                                                       "Caedence"},
    {MIDI_SYSEX_ID_HCN_DESIGNS_LLC_THE_MIDI_MAKER,                                 "HCN Designs, LLC (The MIDI Maker)"},
    {MIDI_SYSEX_ID_PTZOPTICS,                                                      "PTZOptics"},
    {MIDI_SYSEX_ID_NOISE_ENGINEERING,                                              "Noise Engineering"},
    {MIDI_SYSEX_ID_SYNTHESIA_LLC,                                                  "Synthesia LLC"},
    {MIDI_SYSEX_ID_JEFF_WHITEHEAD_LUTHERIE_LLC,                                    "Jeff Whitehead Lutherie LLC"},
    {MIDI_SYSEX_ID_WAMPLER_PEDALS_INC,                                             "Wampler Pedals Inc."},
    {MIDI_SYSEX_ID_TAPIS_MAGIQUE,                                                  "Tapis Magique"},
    {MIDI_SYSEX_ID_LEAF_SECRETS,                                                   "Leaf Secrets"},
    {MIDI_SYSEX_ID_GROOVE_SYNTHESIS_00024A,                                        "Groove Synthesis"},
    {MIDI_SYSEX_ID_AUDIOCIPHER_TECHNOLOGIES_LLC,                                   "Audiocipher Technologies LLC"},
    {MIDI_SYSEX_ID_MELLOTRON_INC,                                                  "Mellotron Inc."},
    {MIDI_SYSEX_ID_HOLOGRAM_ELECTRONICS_LLC,                                       "Hologram Electronics LLC"},
    {MIDI_SYSEX_ID_ICON_AMERICAS_LLC,                                              "iCON Americas, LLC"},
    {MIDI_SYSEX_ID_SINGULAR_SOUND,                                                 "Singular Sound"},
    {MIDI_SYSEX_ID_GENOVATION_INC,                                                 "Genovation Inc"},
    {MIDI_SYSEX_ID_METHOD_RED,                                                     "Method Red"},
    {MIDI_SYSEX_ID_BRAIN_INVENTIONS,                                               "Brain Inventions"},
    {MIDI_SYSEX_ID_SYNERVOZ_COMMUNICATIONS_INC,                                    "Synervoz Communications Inc."},
    {MIDI_SYSEX_ID_HYPERTRIANGLE_INC,                                              "Hypertriangle Inc"},
    {MIDI_SYSEX_ID_DIGIBRASS_LLC,                                                  "DigiBrass LLC"},
    {MIDI_SYSEX_ID_MIDI2_MARKETING_LLC,                                            "MIDI2 Marketing LLC"},
    {MIDI_SYSEX_ID_TAQS_IM,                                                        "TAQS.IM"},
    {MIDI_SYSEX_ID_CSS_DESIGNS,                                                    "CSS Designs"},
    {MIDI_SYSEX_ID_MOZAIC_BEATS,                                                   "Mozaic Beats"},
    {MIDI_SYSEX_ID_PIANODISC_00025A,                                               "PianoDisc"},
    {MIDI_SYSEX_ID_UWYN,                                                           "Uwyn"},
    {MIDI_SYSEX_ID_FSK_AUDIO,                                                      "FSK Audio"},
    {MIDI_SYSEX_ID_ETERNAL_RESEARCH_LLC,                                           "Eternal Research LLC"},
    {MIDI_SYSEX_ID_AZOTEQ_INC,                                                     "Azoteq Inc"},
    {MIDI_SYSEX_ID_HY_MUSIC,                                                       "Hy Music"},
    {MIDI_SYSEX_ID_SOUND_MAGIC_CO_LTD,                                             "Sound Magic Co.,Ltd"},
    {MIDI_SYSEX_ID_DIRTYWAVE,                                                      "Dirtywave"},
    {MIDI_SYSEX_ID_KINOTONE,                                                       "Kinotone"},
    {MIDI_SYSEX_ID_YODER_PRECISION_INSTRUMENTS,                                    "Yoder Precision Instruments"},
    {MIDI_SYSEX_ID_MCLAREN_LABS,                                                   "McLaren Labs"},
    {MIDI_SYSEX_ID_GIGPERFOMER,                                                    "Gigperfomer"},
    {MIDI_SYSEX_ID_GROOVE_SYNTHESIS_000266,                                        "Groove Synthesis"},
    {MIDI_SYSEX_ID_STELLR_AUDIO,                                                   "Stellr Audio"},
    {MIDI_SYSEX_ID_ESSENTIAL_TECHNOLOGY_000269,                                    "Essential technology"},
    {MIDI_SYSEX_ID_LOOKC_MUSIC,                                                    "Lookc Music"},
    {MIDI_SYSEX_ID_HOMEY_MUSIC,                                                    "Homey Music"},
    {MIDI_SYSEX_ID_LORRE_MILL,                                                     "Lorre Mill"},
    {MIDI_SYSEX_ID_PLAYTIME_ENGINEERING,                                           "Playtime Engineering"},
    {MIDI_SYSEX_ID_PIPEORGAN_TECH,                                                 "pipeorgan.tech"},
    {MIDI_SYSEX_ID_SEER_SYSTEMS,                                                   "Seer Systems"},
    {MIDI_SYSEX_ID_AM_COMPONENTS_LLC,                                              "AM Components, LLC"},
    {MIDI_SYSEX_ID_MUSIC_TECHNOLOGIES_GROUP,                                       "Music Technologies Group"},
    {MIDI_SYSEX_ID_GLX_AUDIO_CO,                                                   "GLX Audio Co"},
    {MIDI_SYSEX_ID_FREE_SOFTWARE_FOUNDATION_INC,                                   "Free Software Foundation, Inc"},
    {MIDI_SYSEX_ID_DREAM_SAS,                                                      "Dream SAS"},
    {MIDI_SYSEX_ID_STRAND_LIGHTING,                                                "Strand Lighting"},
    {MIDI_SYSEX_ID_AMEK_DIV_OF_HARMAN_INDUSTRIES,                                  "Amek Div of Harman Industries"},
    {MIDI_SYSEX_ID_CASA_DI_RISPARMIO_DI_LORETO,                                    "Casa Di Risparmio Di Loreto"},
    {MIDI_SYSEX_ID_BOHM_ELECTRONIC_GMBH,                                           "B\u00F6hm electronic GmbH"},
    {MIDI_SYSEX_ID_SYNTEC_DIGITAL_AUDIO,                                           "Syntec Digital Audio"},
    {MIDI_SYSEX_ID_TRIDENT_AUDIO_DEVELOPMENTS,                                     "Trident Audio Developments"},
    {MIDI_SYSEX_ID_REAL_WORLD_STUDIO,                                              "Real World Studio"},
    {MIDI_SYSEX_ID_EVOLUTION_SYNTHESIS_LTD,                                        "Evolution Synthesis, Ltd"},
    {MIDI_SYSEX_ID_YES_TECHNOLOGY,                                                 "Yes Technology"},
    {MIDI_SYSEX_ID_AUDIOMATICA,                                                    "Audiomatica"},
    {MIDI_SYSEX_ID_BONTEMPI_SPA_SIGMA,                                             "Bontempi SpA (Sigma)"},
    {MIDI_SYSEX_ID_F_B_T_ELETTRONICA_SPA,                                          "F.B.T. Elettronica SpA"},
    {MIDI_SYSEX_ID_MIDITEMP_GMBH,                                                  "MidiTemp GmbH"},
    {MIDI_SYSEX_ID_LA_AUDIO_LARKING_AUDIO,                                         "LA Audio (Larking Audio)"},
    {MIDI_SYSEX_ID_ZERO_88_LIGHTING_LIMITED,                                       "Zero 88 Lighting Limited"},
    {MIDI_SYSEX_ID_MICON_AUDIO_ELECTRONICS_GMBH,                                   "Micon Audio Electronics GmbH"},
    {MIDI_SYSEX_ID_FOREFRONT_TECHNOLOGY,                                           "Forefront Technology"},
    {MIDI_SYSEX_ID_STUDIO_AUDIO_AND_VIDEO_LTD,                                     "Studio Audio and Video Ltd."},
    {MIDI_SYSEX_ID_KENTON_ELECTRONICS,                                             "Kenton Electronics"},
    {MIDI_SYSEX_ID_CELCO_ELECTROSONIC,                                             "Celco/ Electrosonic"},
    {MIDI_SYSEX_ID_ADB,                                                            "ADB"},
    {MIDI_SYSEX_ID_MARSHALL_PRODUCTS_LIMITED,                                      "Marshall Products Limited"},
    {MIDI_SYSEX_ID_DDA,                                                            "DDA"},
    {MIDI_SYSEX_ID_BSS_AUDIO_LTD,                                                  "BSS Audio Ltd."},
    {MIDI_SYSEX_ID_MA_LIGHTING_TECHNOLOGY,                                         "MA Lighting Technology"},
    {MIDI_SYSEX_ID_FATAR_SRL_C_O_MUSIC_INDUSTRIES,                                 "Fatar SRL c/o Music Industries"},
    {MIDI_SYSEX_ID_QSC_AUDIO_PRODUCTS_INC,                                         "QSC Audio Products Inc."},
    {MIDI_SYSEX_ID_ARTISAN_CLASIC_ORGAN_INC,                                       "Artisan Clasic Organ Inc."},
    {MIDI_SYSEX_ID_ORLA_SPA,                                                       "Orla Spa"},
    {MIDI_SYSEX_ID_PINNACLE_AUDIO_KLARK_TEKNIK_PLC,                                "Pinnacle Audio (Klark Teknik PLC)"},
    {MIDI_SYSEX_ID_TC_ELECTRONICS,                                                 "TC Electronics"},
    {MIDI_SYSEX_ID_DOEPFER_MUSIKELEKTRONIK_GMBH,                                   "Doepfer Musikelektronik GmbH"},
    {MIDI_SYSEX_ID_CREATIVE_ATC_E_MU,                                              "Creative ATC / E-mu"},
    {MIDI_SYSEX_ID_SEYDDO_MINAMI,                                                  "Seyddo/Minami"},
    {MIDI_SYSEX_ID_LG_ELECTRONICS_GOLDSTAR,                                        "LG Electronics (Goldstar)"},
    {MIDI_SYSEX_ID_MIDISOFT_SAS_DI_M_CIMA_C,                                       "Midisoft sas di M.Cima & C"},
    {MIDI_SYSEX_ID_SAMICK_MUSICAL_INST_CO_LTD,                                     "Samick Musical Inst. Co. Ltd."},
    {MIDI_SYSEX_ID_PENNY_AND_GILES_BOWTHORPE_PLC,                                  "Penny and Giles (Bowthorpe PLC)"},
    {MIDI_SYSEX_ID_ACORN_COMPUTER,                                                 "Acorn Computer"},
    {MIDI_SYSEX_ID_LSC_ELECTRONICS_PTY_LTD,                                        "LSC Electronics Pty. Ltd."},
    {MIDI_SYSEX_ID_FOCUSRITE_NOVATION,                                             "Focusrite/Novation"},
    {MIDI_SYSEX_ID_SAMKYUNG_MECHATRONICS,                                          "Samkyung Mechatronics"},
    {MIDI_SYSEX_ID_MEDELI_ELECTRONICS_CO,                                          "Medeli Electronics Co."},
    {MIDI_SYSEX_ID_CHARLIE_LAB_SRL,                                                "Charlie Lab SRL"},
    {MIDI_SYSEX_ID_BLUE_CHIP_MUSIC_TECHNOLOGY,                                     "Blue Chip Music Technology"},
    {MIDI_SYSEX_ID_BEE_OH_CORP,                                                    "BEE OH Corp"},
    {MIDI_SYSEX_ID_LG_SEMICON_AMERICA,                                             "LG Semicon America"},
    {MIDI_SYSEX_ID_TESI,                                                           "TESI"},
    {MIDI_SYSEX_ID_EMAGIC,                                                         "EMAGIC"},
    {MIDI_SYSEX_ID_BEHRINGER_GMBH,                                                 "Behringer GmbH"},
    {MIDI_SYSEX_ID_ACCESS_MUSIC_ELECTRONICS,                                       "Access Music Electronics"},
    {MIDI_SYSEX_ID_SYNOPTIC,                                                       "Synoptic"},
    {MIDI_SYSEX_ID_HANMESOFT,                                                      "Hanmesoft"},
    {MIDI_SYSEX_ID_TERRATEC_ELECTRONIC_GMBH,                                       "Terratec Electronic GmbH"},
    {MIDI_SYSEX_ID_PROEL_SPA,                                                      "Proel SpA"},
    {MIDI_SYSEX_ID_IBK_MIDI,                                                       "IBK MIDI"},
    {MIDI_SYSEX_ID_IRCAM,                                                          "IRCAM"},
    {MIDI_SYSEX_ID_PROPELLERHEAD_SOFTWARE,                                         "Propellerhead Software"},
    {MIDI_SYSEX_ID_RED_SOUND_SYSTEMS_LTD,                                          "Red Sound Systems Ltd"},
    {MIDI_SYSEX_ID_ELEKTRON_ESI_AB,                                                "Elektron ESI AB"},
    {MIDI_SYSEX_ID_SINTEFEX_AUDIO,                                                 "Sintefex Audio"},
    {MIDI_SYSEX_ID_MAM_MUSIC_AND_MORE,                                             "MAM (Music and More)"},
    {MIDI_SYSEX_ID_AMSARO_GMBH,                                                    "Amsaro GmbH"},
    {MIDI_SYSEX_ID_CDS_ADVANCED_TECHNOLOGY_BV_LANBOX,                              "CDS Advanced Technology BV (Lanbox)"},
    {MIDI_SYSEX_ID_MODE_MACHINES_TOUCHED_BY_SOUND_GMBH,                            "Mode Machines (Touched By Sound GmbH)"},
    {MIDI_SYSEX_ID_DSP_ARTS,                                                       "DSP Arts"},
    {MIDI_SYSEX_ID_PHIL_REES_MUSIC_TECH,                                           "Phil Rees Music Tech"},
    {MIDI_SYSEX_ID_STAMER_MUSIKANLAGEN_GMBH,                                       "Stamer Musikanlagen GmbH"},
    {MIDI_SYSEX_ID_MUSICAL_MUNTANER_S_A_DBA_SOUNDART,                              "Musical Muntaner S.A. dba Soundart"},
    {MIDI_SYSEX_ID_C_MEXX_SOFTWARE,                                                "C-Mexx Software"},
    {MIDI_SYSEX_ID_KLAVIS_TECHNOLOGIES,                                            "Klavis Technologies"},
    {MIDI_SYSEX_ID_NOTEHEADS_AB,                                                   "Noteheads AB"},
    {MIDI_SYSEX_ID_ALGORITHMIX,                                                    "Algorithmix"},
    {MIDI_SYSEX_ID_SKRYDSTRUP_R_D,                                                 "Skrydstrup R&D"},
    {MIDI_SYSEX_ID_PROFESSIONAL_AUDIO_COMPANY,                                     "Professional Audio Company"},
    {MIDI_SYSEX_ID_NEWWAVE_LABS_MADWAVES,                                          "NewWave Labs (MadWaves)"},
    {MIDI_SYSEX_ID_VERMONA,                                                        "Vermona"},
    {MIDI_SYSEX_ID_NOKIA,                                                          "Nokia"},
    {MIDI_SYSEX_ID_WAVE_IDEA,                                                      "Wave Idea"},
    {MIDI_SYSEX_ID_HARTMANN_GMBH,                                                  "Hartmann GmbH"},
    {MIDI_SYSEX_ID_LIONS_TRACS,                                                    "Lion\u2019s Tracs"},
    {MIDI_SYSEX_ID_ANALOGUE_SYSTEMS,                                               "Analogue Systems"},
    {MIDI_SYSEX_ID_FOCAL_JMLAB,                                                    "Focal-JMlab"},
    {MIDI_SYSEX_ID_RINGWAY_ELECTRONICS_CHANG_ZHOU_CO_LTD,                          "Ringway Electronics (Chang-Zhou) Co Ltd"},
    {MIDI_SYSEX_ID_FAITH_TECHNOLOGIES_DIGIPLUG,                                    "Faith Technologies (Digiplug)"},
    {MIDI_SYSEX_ID_SHOWWORKS,                                                      "Showworks"},
    {MIDI_SYSEX_ID_MANIKIN_ELECTRONIC,                                             "Manikin Electronic"},
    {MIDI_SYSEX_ID_1_COME_TECH,                                                    "1 Come Tech"},
    {MIDI_SYSEX_ID_PHONIC_CORP,                                                    "Phonic Corp"},
    {MIDI_SYSEX_ID_DOLBY_AUSTRALIA_LAKE,                                           "Dolby Australia (Lake)"},
    {MIDI_SYSEX_ID_SILANSYS_TECHNOLOGIES,                                          "Silansys Technologies"},
    {MIDI_SYSEX_ID_WINBOND_ELECTRONICS,                                            "Winbond Electronics"},
    {MIDI_SYSEX_ID_CINETIX_MEDIEN_UND_INTERFACE_GMBH,                              "Cinetix Medien und Interface GmbH"},
    {MIDI_SYSEX_ID_A_G_SOLUZIONI_DIGITALI,                                         "A&G Soluzioni Digitali"},
    {MIDI_SYSEX_ID_SEQUENTIX_GMBH,                                                 "Sequentix GmbH"},
    {MIDI_SYSEX_ID_ORAM_PRO_AUDIO,                                                 "Oram Pro Audio"},
    {MIDI_SYSEX_ID_BE4_LTD,                                                        "Be4 Ltd"},
    {MIDI_SYSEX_ID_INFECTION_MUSIC,                                                "Infection Music"},
    {MIDI_SYSEX_ID_CENTRAL_MUSIC_CO_CME,                                           "Central Music Co. (CME)"},
    {MIDI_SYSEX_ID_GENOQS_MACHINES_GMBH,                                           "genoQs Machines GmbH"},
    {MIDI_SYSEX_ID_MEDIALON,                                                       "Medialon"},
    {MIDI_SYSEX_ID_WAVES_AUDIO_LTD,                                                "Waves Audio Ltd"},
    {MIDI_SYSEX_ID_JERASH_LABS,                                                    "Jerash Labs"},
    {MIDI_SYSEX_ID_DA_FACT,                                                        "Da Fact"},
    {MIDI_SYSEX_ID_ELBY_DESIGNS,                                                   "Elby Designs"},
    {MIDI_SYSEX_ID_SPECTRAL_AUDIO,                                                 "Spectral Audio"},
    {MIDI_SYSEX_ID_ARTURIA,                                                        "Arturia"},
    {MIDI_SYSEX_ID_VIXID,                                                          "Vixid"},
    {MIDI_SYSEX_ID_C_THRU_MUSIC,                                                   "C-Thru Music"},
    {MIDI_SYSEX_ID_YA_HORNG_ELECTRONIC_CO_LTD,                                     "Ya Horng Electronic Co LTD"},
    {MIDI_SYSEX_ID_SM_PRO_AUDIO,                                                   "SM Pro Audio"},
    {MIDI_SYSEX_ID_OTO_MACHINES,                                                   "OTO Machines"},
    {MIDI_SYSEX_ID_ELZAB_S_A_G_LAB,                                                "ELZAB S.A. (G LAB)"},
    {MIDI_SYSEX_ID_BLACKSTAR_AMPLIFICATION_LTD,                                    "Blackstar Amplification Ltd"},
    {MIDI_SYSEX_ID_M3I_TECHNOLOGIES_GMBH,                                          "M3i Technologies GmbH"},
    {MIDI_SYSEX_ID_GEMALTO_FROM_XIRING,                                            "Gemalto (from Xiring)"},
    {MIDI_SYSEX_ID_PROSTAGE_SL,                                                    "Prostage SL"},
    {MIDI_SYSEX_ID_TEENAGE_ENGINEERING,                                            "Teenage Engineering"},
    {MIDI_SYSEX_ID_TOBIAS_ERICHSEN_CONSULTING,                                     "Tobias Erichsen Consulting"},
    {MIDI_SYSEX_ID_NIXER_LTD,                                                      "Nixer Ltd"},
    {MIDI_SYSEX_ID_HANPIN_ELECTRON_CO_LTD,                                         "Hanpin Electron Co Ltd"},
    {MIDI_SYSEX_ID_MIDI_HARDWARE_R_SOWA,                                           "\"MIDI-hardware\" R.Sowa"},
    {MIDI_SYSEX_ID_BEYOND_MUSIC_INDUSTRIAL_LTD,                                    "Beyond Music Industrial Ltd"},
    {MIDI_SYSEX_ID_KISS_BOX_B_V,                                                   "Kiss Box B.V."},
    {MIDI_SYSEX_ID_MISA_DIGITAL_TECHNOLOGIES_LTD,                                  "Misa Digital Technologies Ltd"},
    {MIDI_SYSEX_ID_AI_MUSICS_TECHNOLOGY_INC,                                       "AI Musics Technology Inc"},
    {MIDI_SYSEX_ID_SERATO_INC_LP,                                                  "Serato Inc LP"},
    {MIDI_SYSEX_ID_LIMEX,                                                          "Limex"},
    {MIDI_SYSEX_ID_KYODDAY_TOKAI,                                                  "Kyodday (Tokai)"},
    {MIDI_SYSEX_ID_MUTABLE_INSTRUMENTS,                                            "Mutable Instruments"},
    {MIDI_SYSEX_ID_PRESONUS_SOFTWARE_LTD,                                          "PreSonus Software Ltd"},
    {MIDI_SYSEX_ID_INGENICO_WAS_XIRING,                                            "Ingenico (was Xiring)"},
    {MIDI_SYSEX_ID_FAIRLIGHT_INSTRUMENTS_PTY_LTD,                                  "Fairlight Instruments Pty Ltd"},
    {MIDI_SYSEX_ID_MUSICOM_LAB,                                                    "Musicom Lab"},
    {MIDI_SYSEX_ID_MODAL_ELECTRONICS_MODULUS_VACOLOCO,                             "Modal Electronics (Modulus/VacoLoco)"},
    {MIDI_SYSEX_ID_RWA_HONG_KONG_LIMITED,                                          "RWA (Hong Kong) Limited"},
    {MIDI_SYSEX_ID_NATIVE_INSTRUMENTS,                                             "Native Instruments"},
    {MIDI_SYSEX_ID_NAONEXT,                                                        "Naonext"},
    {MIDI_SYSEX_ID_MFB,                                                            "MFB"},
    {MIDI_SYSEX_ID_TEKNEL_RESEARCH,                                                "Teknel Research"},
    {MIDI_SYSEX_ID_PLOYTEC_GMBH,                                                   "Ploytec GmbH"},
    {MIDI_SYSEX_ID_SURFIN_KANGAROO_STUDIO,                                         "Surfin Kangaroo Studio"},
    {MIDI_SYSEX_ID_PHILIPS_ELECTRONICS_HK_LTD,                                     "Philips Electronics HK Ltd"},
    {MIDI_SYSEX_ID_ROLI_LTD,                                                       "ROLI Ltd"},
    {MIDI_SYSEX_ID_PANDA_AUDIO_LTD,                                                "Panda-Audio Ltd"},
    {MIDI_SYSEX_ID_BAUM_SOFTWARE,                                                  "BauM Software"},
    {MIDI_SYSEX_ID_MACHINEWERKS_LTD,                                               "Machinewerks Ltd."},
    {MIDI_SYSEX_ID_XIAMEN_ELANE_ELECTRONICS,                                       "Xiamen Elane Electronics"},
    {MIDI_SYSEX_ID_MARSHALL_AMPLIFICATION_PLC,                                     "Marshall Amplification PLC"},
    {MIDI_SYSEX_ID_KIWITECHNICS_LTD,                                               "Kiwitechnics Ltd"},
    {MIDI_SYSEX_ID_ROB_PAPEN,                                                      "Rob Papen"},
    {MIDI_SYSEX_ID_SPICETONE_OU,                                                   "Spicetone OU"},
    {MIDI_SYSEX_ID_V3SOUND,                                                        "V3Sound"},
    {MIDI_SYSEX_ID_IK_MULTIMEDIA,                                                  "IK Multimedia"},
    {MIDI_SYSEX_ID_NOVALIA_LTD,                                                    "Novalia Ltd"},
    {MIDI_SYSEX_ID_MODOR_MUSIC,                                                    "Modor Music"},
    {MIDI_SYSEX_ID_ABLETON,                                                        "Ableton"},
    {MIDI_SYSEX_ID_DTRONICS,                                                       "Dtronics"},
    {MIDI_SYSEX_ID_ZAQ_AUDIO,                                                      "ZAQ Audio"},
    {MIDI_SYSEX_ID_MUABAOBAO_EDUCATION_TECHNOLOGY_CO_LTD,                          "Muabaobao Education Technology Co Ltd"},
    {MIDI_SYSEX_ID_FLUX_EFFECTS,                                                   "Flux Effects"},
    {MIDI_SYSEX_ID_AUDIOTHINGIES_MCDA,                                             "Audiothingies (MCDA)"},
    {MIDI_SYSEX_ID_RETROKITS,                                                      "Retrokits"},
    {MIDI_SYSEX_ID_MORNINGSTAR_FX_PTE_LTD,                                         "Morningstar FX Pte Ltd"},
    {MIDI_SYSEX_ID_CHANGSHA_HOTONE_AUDIO_CO_LTD,                                   "Changsha Hotone Audio Co Ltd"},
    {MIDI_SYSEX_ID_EXPRESSIVE_E,                                                   "Expressive E"},
    {MIDI_SYSEX_ID_EXPERT_SLEEPERS_LTD,                                            "Expert Sleepers Ltd"},
    {MIDI_SYSEX_ID_TIMECODE_VISION_TECHNOLOGY,                                     "Timecode-Vision Technology"},
    {MIDI_SYSEX_ID_HORNBERG_RESEARCH_GBR,                                          "Hornberg Research GbR"},
    {MIDI_SYSEX_ID_SONIC_POTIONS,                                                  "Sonic Potions"},
    {MIDI_SYSEX_ID_AUDIOFRONT,                                                     "Audiofront"},
    {MIDI_SYSEX_ID_FREDS_LAB,                                                      "Fred\u2019s Lab"},
    {MIDI_SYSEX_ID_AUDIO_MODELING,                                                 "Audio Modeling"},
    {MIDI_SYSEX_ID_C_BECHSTEIN_DIGITAL_GMBH,                                       "C. Bechstein Digital GmbH"},
    {MIDI_SYSEX_ID_MOTAS_ELECTRONICS_LTD,                                          "Motas Electronics Ltd"},
    {MIDI_SYSEX_ID_ELK_AUDIO,                                                      "Elk Audio"},
    {MIDI_SYSEX_ID_SONIC_ACADEMY_LTD,                                              "Sonic Academy Ltd"},
    {MIDI_SYSEX_ID_BOME_SOFTWARE,                                                  "Bome Software"},
    {MIDI_SYSEX_ID_AODYO_SAS,                                                      "AODYO SAS"},
    {MIDI_SYSEX_ID_PIANOFORCE_S_R_O,                                               "Pianoforce S.R.O"},
    {MIDI_SYSEX_ID_DREADBOX_P_C,                                                   "Dreadbox P.C."},
    {MIDI_SYSEX_ID_TOUCHKEYS_INSTRUMENTS_LTD,                                      "TouchKeys Instruments Ltd"},
    {MIDI_SYSEX_ID_THE_GIGRIG_LTD,                                                 "The Gigrig Ltd"},
    {MIDI_SYSEX_ID_ALM_CO,                                                         "ALM Co"},
    {MIDI_SYSEX_ID_CH_SOUND_DESIGN,                                                "CH Sound Design"},
    {MIDI_SYSEX_ID_BEAT_BARS,                                                      "Beat Bars"},
    {MIDI_SYSEX_ID_BLOKAS,                                                         "Blokas"},
    {MIDI_SYSEX_ID_GEWA_MUSIC_GMBH,                                                "GEWA Music GmbH"},
    {MIDI_SYSEX_ID_DADAMACHINES,                                                   "dadamachines"},
    {MIDI_SYSEX_ID_AUGMENTED_INSTRUMENTS_LTD_BELA,                                 "Augmented Instruments Ltd (Bela)"},
    {MIDI_SYSEX_ID_SUPERCRITICAL_LTD,                                              "Supercritical Ltd"},
    {MIDI_SYSEX_ID_GENKI_INSTRUMENTS,                                              "Genki Instruments"},
    {MIDI_SYSEX_ID_MARIENBERG_DEVICES_GERMANY,                                     "Marienberg Devices Germany"},
    {MIDI_SYSEX_ID_SUPPERWARE_LTD,                                                 "Supperware Ltd"},
    {MIDI_SYSEX_ID_IMOXPLUS_BVBA,                                                  "Imoxplus BVBA"},
    {MIDI_SYSEX_ID_SWAPP_TECHNOLOGIES_SRL,                                         "Swapp Technologies SRL"},
    {MIDI_SYSEX_ID_ELECTRA_ONE_S_R_O,                                              "Electra One S.R.O."},
    {MIDI_SYSEX_ID_DIGITAL_CLEF_LIMITED,                                           "Digital Clef Limited"},
    {MIDI_SYSEX_ID_PAUL_WHITTINGTON_GROUP_LTD,                                     "Paul Whittington Group Ltd"},
    {MIDI_SYSEX_ID_MUSIC_HACKSPACE,                                                "Music Hackspace"},
    {MIDI_SYSEX_ID_BITWIG_GMBH,                                                    "Bitwig GMBH"},
    {MIDI_SYSEX_ID_ENHANCIA,                                                       "Enhancia"},
    {MIDI_SYSEX_ID_KV_331,                                                         "KV 331"},
    {MIDI_SYSEX_ID_TEHNICADELARTE,                                                 "Tehnicadelarte"},
    {MIDI_SYSEX_ID_ENDLESSS_STUDIO,                                                "Endlesss Studio"},
    {MIDI_SYSEX_ID_DONGGUAN_MIDIPLUS_CO_LTD,                                       "Dongguan MIDIPLUS Co., LTD"},
    {MIDI_SYSEX_ID_GRACELY_PTY_LTD,                                                "Gracely Pty Ltd."},
    {MIDI_SYSEX_ID_EMBODME,                                                        "Embodme"},
    {MIDI_SYSEX_ID_MUSESCORE,                                                      "MuseScore"},
    {MIDI_SYSEX_ID_EPFL_E_LAB,                                                     "EPFL (E-Lab)"},
    {MIDI_SYSEX_ID_ORB3_LTD,                                                       "Orb3 Ltd."},
    {MIDI_SYSEX_ID_PITCH_INNOVATIONS,                                              "Pitch Innovations"},
    {MIDI_SYSEX_ID_PLAYCES,                                                        "Playces"},
    {MIDI_SYSEX_ID_UDO_AUDIO_LTD,                                                  "UDO Audio LTD"},
    {MIDI_SYSEX_ID_RSS_SOUND_DESIGN,                                               "RSS Sound Design"},
    {MIDI_SYSEX_ID_NONLINEAR_LABS_GMBH,                                            "Nonlinear Labs GmbH"},
    {MIDI_SYSEX_ID_ROBKOO_INFORMATION_TECHNOLOGIES_CO_LTD,                         "Robkoo Information & Technologies Co., Ltd."},
    {MIDI_SYSEX_ID_CARI_ELECTRONIC,                                                "Cari Electronic"},
    {MIDI_SYSEX_ID_OXI_ELECTRONIC_INSTRUMENTS_SL,                                  "Oxi Electronic Instruments SL"},
    {MIDI_SYSEX_ID_XMPT,                                                           "XMPT"},
    {MIDI_SYSEX_ID_SHANGHAI_HUAXIN_MUSICAL_INSTRUMENT,                             "SHANGHAI HUAXIN MUSICAL INSTRUMENT"},
    {MIDI_SYSEX_ID_SHENZHEN_HUASHI_TECHNOLOGY_CO_LTD,                              "Shenzhen Huashi Technology Co., Ltd"},
    {MIDI_SYSEX_ID_GUANGZHOU_RANTION_TECHNOLOGY_CO_LTD,                            "Guangzhou Rantion Technology Co., Ltd."},
    {MIDI_SYSEX_ID_RYME_MUSIC,                                                     "Ryme Music"},
    {MIDI_SYSEX_ID_GS_MUSIC,                                                       "GS Music"},
    {MIDI_SYSEX_ID_SHENZHEN_FLAMMA_INNOVATION_CO_LTD,                              "Shenzhen Flamma Innovation Co., Ltd"},
    {MIDI_SYSEX_ID_SHENZHEN_MOOER_AUDIO_CO_LTD,                                    "Shenzhen Mooer Audio Co.,LTD."},
    {MIDI_SYSEX_ID_RAW_MATERIAL_SOFTWARE_LIMITED_JUCE,                             "Raw Material Software Limited (JUCE)"},
    {MIDI_SYSEX_ID_BIRDKIDS,                                                       "Birdkids"},
    {MIDI_SYSEX_ID_BEIJING_QIANYINHULIAN_TECH_CO,                                  "Beijing QianYinHuLian Tech. Co"},
    {MIDI_SYSEX_ID_NIMIKRY_MUSIC_OG,                                               "Nimikry Music OG"},
    {MIDI_SYSEX_ID_NEWZIK,                                                         "Newzik"},
    {MIDI_SYSEX_ID_HAMBURG_WAVE,                                                   "Hamburg Wave"},
    {MIDI_SYSEX_ID_GRIMM_AUDIO,                                                    "Grimm Audio"},
    {MIDI_SYSEX_ID_ARCANA_INSTRUMENTS_LTD,                                         "Arcana Instruments LTD."},
    {MIDI_SYSEX_ID_GAMECHANGER_AUDIO,                                              "GameChanger Audio"},
    {MIDI_SYSEX_ID_OAKTONE,                                                        "OakTone"},
    {MIDI_SYSEX_ID_THE_DIGI_GURDY_A_MIDI_HURDY_GURDY,                              "The Digi-Gurdy: A MIDI Hurdy Gurdy"},
    {MIDI_SYSEX_ID_MUSIKRAKEN,                                                     "MusiKraken"},
    {MIDI_SYSEX_ID_PHOTOSYNTH_INTERFACE,                                           "PhotoSynth > InterFACE"},
    {MIDI_SYSEX_ID_INSTRUMENTS_OF_THINGS,                                          "Instruments of Things"},
    {MIDI_SYSEX_ID_OODI,                                                           "oodi"},
    {MIDI_SYSEX_ID_KOMIRES_SP_Z_O_O,                                               "Komires Sp. z o.o."},
    {MIDI_SYSEX_ID_LEHLE_GMBH,                                                     "Lehle GmbH"},
    {MIDI_SYSEX_ID_JOUE_MUSIC_INSTRUMENTS,                                         "Jou\u00E9 Music Instruments"},
    {MIDI_SYSEX_ID_GUANGZHOU_PEARL_RIVER_AMASON_DIGITAL_MUSICAL_INSTRUMENT_CO_LTD, "Guangzhou Pearl River Amason Digital Musical Instrument Co. Ltd"},
    {MIDI_SYSEX_ID_RHESUS_ENGINEERING_GMBH,                                        "Rhesus Engineering GmbH"},
    {MIDI_SYSEX_ID_BREMMERS_AUDIO_DESIGN,                                          "Bremmers Audio Design"},
    {MIDI_SYSEX_ID_CHERUB_TECHNOLOGY_CO_LTD,                                       "Cherub Technology Co., Ltd"},
    {MIDI_SYSEX_ID_SYNTHSTROM_AUDIBLE,                                             "Synthstrom Audible"},
    {MIDI_SYSEX_ID_NEURAL_DSP_TECHNOLOGIES_OY,                                     "Neural DSP Technologies Oy"},
    {MIDI_SYSEX_ID_2BOX_AB,                                                        "2box AB"},
    {MIDI_SYSEX_ID_INTUITIVE_INSTRUMENTS,                                          "Intuitive Instruments"},
    {MIDI_SYSEX_ID_TWISTED_ELECTRONS,                                              "Twisted-electrons"},
    {MIDI_SYSEX_ID_WILDCARD_ENGINEERING_BV,                                        "Wildcard Engineering BV"},
    {MIDI_SYSEX_ID_DATO_MUSICAL_INSTRUMENTS,                                       "Dato Musical Instruments"},
    {MIDI_SYSEX_ID_JTJ_AUDIO,                                                      "JTJ AUDIO"},
    {MIDI_SYSEX_ID_MELBOURNE_INSTRUMENTS,                                          "Melbourne Instruments"},
    {MIDI_SYSEX_ID_AZMINO,                                                         "AZMINO"},
    {MIDI_SYSEX_ID_TELEMIDI_TRIGITAL_PTY_LTD,                                      "TELEMIDI (TRIGITAL PTY LTD)"},
    {MIDI_SYSEX_ID_TYLIUM,                                                         "Tylium"},
    {MIDI_SYSEX_ID_ENGINEERING_LAB,                                                "Engineering Lab"},
    {MIDI_SYSEX_ID_ARCHAEA_MODULAR_SYNTHESIS_LTD,                                  "Archaea Modular Synthesis Ltd."},
    {MIDI_SYSEX_ID_TENTACLE_SYNC_GMBH,                                             "Tentacle Sync GmbH"},
    {MIDI_SYSEX_ID_MISA_DIGITAL_PTY_LTD,                                           "Misa Digital Pty Ltd"},
    {MIDI_SYSEX_ID_HEAVY_PROCRASTINATION_INDUSTRIES_APS,                           "Heavy Procrastination Industries ApS"},
    {MIDI_SYSEX_ID_TELEPATHIC_PTY_LTD,                                             "Telepathic Pty Ltd"},
    {MIDI_SYSEX_ID_NEOHARP_LLC_FZ,                                                 "Neoharp LLC-FZ"},
    {MIDI_SYSEX_ID_RHODES_MUSIC_GROUP,                                             "Rhodes Music Group"},
    {MIDI_SYSEX_ID_HALBESTUNDE_GMBH,                                               "Halbestunde GmbH"},
    {MIDI_SYSEX_ID_FLUQE,                                                          "FluQe"},
    {MIDI_SYSEX_ID_BLACKMAGIC_DESIGN_PTY_LTD,                                      "Blackmagic Design Pty. Ltd."},
    {MIDI_SYSEX_ID_TANGIBLE_WAVES,                                                 "Tangible Waves"},
    {MIDI_SYSEX_ID_HUEBNER_INFORMATIONSELEKTRONIK,                                 "Huebner Informationselektronik"},
    {MIDI_SYSEX_ID_ADDICTIVE_INSTRUMENTS,                                          "Addictive Instruments"},
    {MIDI_SYSEX_ID_LIGHTREFT_KK,                                                   "Lightreft KK"},
    {MIDI_SYSEX_ID_MORPHOR,                                                        "Morphor"},
    {MIDI_SYSEX_ID_FILISIA_INTERFACES_LTD,                                         "Filisia Interfaces LtD"},
    {MIDI_SYSEX_ID_NEUZEIT_INSTRUMENTS,                                            "Neuzeit Instruments"},
    {MIDI_SYSEX_ID_KOMA_ELEKTRONIK,                                                "KOMA Elektronik"},
    {MIDI_SYSEX_ID_FRESHWATER_INSTRUMENTS,                                         "Freshwater Instruments"},
    {MIDI_SYSEX_ID_FULL_FAT,                                                       "Full Fat"},
    {MIDI_SYSEX_ID_GOOROO_CONTROLLERS,                                             "Gooroo Controllers"},
    {MIDI_SYSEX_ID_JK,                                                             "JK"},
    {MIDI_SYSEX_ID_SHENZHEN_DALE_SENSOR_TECH_CO_LTD,                               "Shenzhen Dale Sensor Tech Co., Ltd."},
    {MIDI_SYSEX_ID_ANTESCOFO,                                                      "Antescofo"},
    {MIDI_SYSEX_ID_CRIMSON_TECHNOLOGY_INC,                                         "Crimson Technology Inc."},
    {MIDI_SYSEX_ID_SOFTBANK_MOBILE_CORP,                                           "Softbank Mobile Corp"},
    {MIDI_SYSEX_ID_D_M_HOLDINGS_INC,                                               "D&M Holdings Inc."},
    {MIDI_SYSEX_ID_XING_INC,                                                       "Xing Inc."},
    {MIDI_SYSEX_ID_ALPHATHETA_CORPORATION,                                         "AlphaTheta Corporation"},
    {MIDI_SYSEX_ID_PIONEER_CORPORATION,                                            "Pioneer Corporation"},
    {MIDI_SYSEX_ID_SLIK_CORPORATION,                                               "Slik Corporation"},
    {MIDI_SYSEX_ID_SIGBOOST_INC,                                                   "sigboost Inc."},
    {MIDI_SYSEX_ID_LOST_TECHNOLOGY,                                                "Lost Technology"},
    {MIDI_SYSEX_ID_FAN_WIND_GOD,                                                   "Fan Wind God"},
    {MIDI_SYSEX_ID_TSUKUBA_SCIENTIFIC_CO_LTD,                                      "Tsukuba Scientific Co., Ltd."},
    {MIDI_SYSEX_ID_SONICWARE_CO_LTD,                                               "Sonicware Co., Ltd."},
    {MIDI_SYSEX_ID_POPPY_SEED_STUDIO,                                              "Poppy Seed Studio"},
    {MIDI_SYSEX_ID_BLACK_CORPORATION_LLC,                                          "BLACK CORPORATION LLC"},
    {MIDI_SYSEX_ID_G_TONE_GIKEN_CO_LTD,                                            "G-TONE Giken Co., Ltd."},
    {MIDI_SYSEX_ID_NITROPLASMA,                                                    "NITROPLASMA"},
    {0,                                                                            NULL}
};
value_string_ext midi_sysex_extended_id_vals_ext = VALUE_STRING_EXT_INIT(midi_sysex_extended_id_vals);
